/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting;

import com.chutneytesting.EngineActionsConfiguration;
import com.chutneytesting.action.domain.ActionTemplateLoader;
import com.chutneytesting.action.domain.ActionTemplateLoaders;
import com.chutneytesting.action.domain.ActionTemplateParserV2;
import com.chutneytesting.action.domain.ActionTemplateRegistry;
import com.chutneytesting.action.domain.DefaultActionTemplateRegistry;
import com.chutneytesting.action.infra.DefaultActionTemplateLoader;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.injectable.ActionsConfiguration;
import com.chutneytesting.engine.api.execution.EmbeddedTestEngine;
import com.chutneytesting.engine.api.execution.TestEngine;
import com.chutneytesting.engine.domain.delegation.DelegationService;
import com.chutneytesting.engine.domain.execution.ExecutionEngine;
import com.chutneytesting.engine.domain.execution.ExecutionManager;
import com.chutneytesting.engine.domain.execution.engine.DefaultExecutionEngine;
import com.chutneytesting.engine.domain.execution.engine.DefaultStepExecutor;
import com.chutneytesting.engine.domain.execution.engine.evaluation.StepDataEvaluator;
import com.chutneytesting.engine.domain.execution.evaluation.SpelFunctionCallback;
import com.chutneytesting.engine.domain.execution.evaluation.SpelFunctions;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategies;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategy;
import com.chutneytesting.engine.domain.report.Reporter;
import com.chutneytesting.engine.infrastructure.delegation.HttpClient;
import com.chutneytesting.tools.Streams;
import com.chutneytesting.tools.ThrowingFunction;
import com.chutneytesting.tools.loader.ExtensionLoaders;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ExecutionConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionConfiguration.class);
    private final ActionTemplateRegistry actionTemplateRegistry;
    private final Reporter reporter;
    private final ExecutionEngine executionEngine;
    private final TestEngine embeddedTestEngine;
    private final SpelFunctions spelFunctions;
    private final Set<StepExecutionStrategy> stepExecutionStrategies;
    private final Long reporterTTL;

    public ExecutionConfiguration() {
        this(5L, Executors.newFixedThreadPool(10), Collections.emptyMap(), null, null);
    }

    public ExecutionConfiguration(Long reporterTTL, ExecutorService actionExecutor, Map<String, String> actionsConfiguration, String user, String password) {
        this.reporterTTL = reporterTTL;
        ActionTemplateLoader actionTemplateLoaderV2 = this.createActionTemplateLoaderV2();
        this.spelFunctions = this.createSpelFunctions();
        this.stepExecutionStrategies = this.createStepExecutionStrategies();
        this.actionTemplateRegistry = new DefaultActionTemplateRegistry(new ActionTemplateLoaders(Collections.singletonList(actionTemplateLoaderV2)));
        this.reporter = this.createReporter();
        this.executionEngine = this.createExecutionEngine(actionExecutor, user, password);
        this.embeddedTestEngine = this.createEmbeddedTestEngine(new EngineActionsConfiguration(actionsConfiguration));
    }

    public ActionTemplateRegistry actionTemplateRegistry() {
        return this.actionTemplateRegistry;
    }

    public TestEngine embeddedTestEngine() {
        return this.embeddedTestEngine;
    }

    public Set<StepExecutionStrategy> stepExecutionStrategies() {
        return this.stepExecutionStrategies;
    }

    public Reporter reporter() {
        return this.reporter;
    }

    public ExecutionEngine executionEngine() {
        return this.executionEngine;
    }

    private ActionTemplateLoader createActionTemplateLoaderV2() {
        return new DefaultActionTemplateLoader<Action>("chutney.actions", Action.class, new ActionTemplateParserV2());
    }

    private SpelFunctions createSpelFunctions() {
        SpelFunctionCallback spelFunctionCallback = new SpelFunctionCallback();
        ExtensionLoaders.classpathToClass((String)"META-INF/extension/chutney.functions").load().forEach(c -> ReflectionUtils.doWithMethods((Class)c, (ReflectionUtils.MethodCallback)spelFunctionCallback));
        return spelFunctionCallback.getSpelFunctions();
    }

    private Set<StepExecutionStrategy> createStepExecutionStrategies() {
        return ExtensionLoaders.classpathToClass((String)"META-INF/extension/chutney.strategies").load().stream().map(ThrowingFunction.toUnchecked(ExecutionConfiguration::instantiate)).map(Streams.identity(c -> LOGGER.debug("Loading strategy: " + c.getType() + " (" + c.getClass().getSimpleName() + ")"))).collect(Collectors.toSet());
    }

    private Reporter createReporter() {
        return new Reporter(this.reporterTTL);
    }

    private ExecutionEngine createExecutionEngine(ExecutorService actionExecutor, String user, String password) {
        return new DefaultExecutionEngine(new StepDataEvaluator(this.spelFunctions), new StepExecutionStrategies(this.stepExecutionStrategies), new DelegationService(new DefaultStepExecutor(this.actionTemplateRegistry), new HttpClient(user, password)), this.reporter, actionExecutor);
    }

    private TestEngine createEmbeddedTestEngine(ActionsConfiguration actionsConfiguration) {
        return new EmbeddedTestEngine(this.executionEngine, this.reporter, new ExecutionManager(), actionsConfiguration);
    }

    private static <T> T instantiate(Class<?> clazz) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        return (T)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

