/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.strategies;

import com.chutneytesting.engine.domain.execution.ScenarioExecution;
import com.chutneytesting.engine.domain.execution.StepDefinition;
import com.chutneytesting.engine.domain.execution.StepDefinitionBuilder;
import com.chutneytesting.engine.domain.execution.engine.evaluation.StepDataEvaluator;
import com.chutneytesting.engine.domain.execution.engine.scenario.ScenarioContext;
import com.chutneytesting.engine.domain.execution.engine.step.Step;
import com.chutneytesting.engine.domain.execution.report.Status;
import com.chutneytesting.engine.domain.execution.strategies.DefaultStepExecutionStrategy;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategies;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategy;
import com.chutneytesting.engine.domain.execution.strategies.StepStrategyDefinition;
import com.chutneytesting.engine.domain.execution.strategies.StrategyProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class StepIterationStrategy
implements StepExecutionStrategy {
    @Override
    public String getType() {
        return "for";
    }

    @Override
    public Status execute(ScenarioExecution scenarioExecution, Step step, ScenarioContext scenarioContext, Map<String, Object> localContext, StepExecutionStrategies strategies) {
        StepStrategyDefinition strategyDefinition = step.strategy().orElseThrow(() -> new IllegalArgumentException("Strategy definition cannot be empty"));
        List<Map<String, Object>> dataset = StepIterationStrategy.getDataset(step, scenarioContext, strategyDefinition, step.dataEvaluator());
        String indexName = Optional.ofNullable(strategyDefinition.strategyProperties.get("index")).orElse("i");
        step.beginExecution(scenarioExecution);
        AtomicInteger index = new AtomicInteger(0);
        if (step.isParentStep()) {
            List<Step> subSteps = List.copyOf(step.subSteps());
            step.removeStepExecution();
            List<Pair> iterations = dataset.stream().map(iterationContext -> this.buildParentIteration(indexName, index.getAndIncrement(), step, subSteps, (Map<String, Object>)iterationContext)).peek(p -> step.addStepExecution((Step)p.getLeft())).toList();
            iterations.forEach(it -> DefaultStepExecutionStrategy.instance.execute(scenarioExecution, (Step)it.getLeft(), scenarioContext, (Map)it.getRight(), strategies));
        } else {
            List<Pair> iterations = dataset.stream().map(iterationContext -> this.buildIteration(indexName, index.getAndIncrement(), step, (Map<String, Object>)iterationContext)).peek(e -> step.addStepExecution((Step)e.getKey())).toList();
            iterations.forEach(it -> ((Step)it.getLeft()).execute(scenarioExecution, scenarioContext, (Map)it.getRight()));
        }
        step.endExecution(scenarioExecution);
        return step.status();
    }

    private static List<Map<String, Object>> getDataset(Step step, ScenarioContext scenarioContext, StepStrategyDefinition strategyDefinition, StepDataEvaluator evaluator) {
        List dataset = (List)step.dataEvaluator().evaluate(strategyDefinition.strategyProperties.get("dataset"), scenarioContext);
        if (dataset.isEmpty()) {
            throw new IllegalArgumentException("Step iteration cannot have empty dataset");
        }
        List<Map<String, Object>> evaluatedDataset = dataset.stream().map(iterationData -> iterationData.entrySet().stream().map(e -> Map.entry((String)e.getKey(), evaluator.evaluate(e.getValue(), scenarioContext))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).toList();
        return evaluatedDataset;
    }

    private Pair<Step, Map<String, Object>> buildParentIteration(String indexName, Integer index, Step step, List<Step> subSteps, Map<String, Object> iterationContext) {
        StepDefinition newDef = this.iterationDefinition(indexName, index, step.definition(), step.dataEvaluator(), new StepStrategyDefinition("", new StrategyProperties()), iterationContext);
        List<Step> newSubSteps = subSteps.stream().map(subStep -> {
            StepDefinition subStepDef = this.iterationDefinition(indexName, index, subStep.definition(), subStep.dataEvaluator(), subStep.strategy().orElse(new StepStrategyDefinition("", new StrategyProperties())), iterationContext);
            return new Step(subStep.dataEvaluator(), subStepDef, subStep.executor(), subStep.subSteps());
        }).collect(Collectors.toList());
        return Pair.of((Object)new Step(step.dataEvaluator(), newDef, step.executor(), newSubSteps), iterationContext);
    }

    private Pair<Step, Map<String, Object>> buildIteration(String indexName, Integer index, Step step, Map<String, Object> iterationContext) {
        return Pair.of((Object)new Step(step.dataEvaluator(), this.iterationDefinition(indexName, index, step.definition(), step.dataEvaluator(), new StepStrategyDefinition("", new StrategyProperties()), iterationContext), step.executor(), Collections.emptyList()), iterationContext);
    }

    private StepDefinition iterationDefinition(String indexName, Integer index, StepDefinition definition, StepDataEvaluator evaluator, StepStrategyDefinition strategyDefinition, Map<String, Object> iterationContext) {
        return StepDefinitionBuilder.copyFrom(definition).withName(evaluator.evaluateString(this.index(indexName, index, definition.name), iterationContext)).withInputs(this.index(indexName, index, definition.inputs())).withOutputs(this.index(indexName, index, definition.outputs)).withValidations(this.index(indexName, index, definition.validations)).withStrategy(strategyDefinition).build();
    }

    private String index(String indexName, Integer index, String string) {
        return string.replace("<" + indexName + ">", index.toString());
    }

    private Map<String, Object> index(String indexName, Integer index, Map<String, Object> inputs) {
        return inputs.entrySet().stream().collect(Collectors.toMap(e -> this.index(indexName, index, (String)e.getKey()), e -> this.index(indexName, index, e.getValue())));
    }

    private List<Object> index(String indexName, Integer index, List<Object> inputs) {
        return inputs.stream().map(e -> this.index(indexName, index, e)).toList();
    }

    private Object index(String indexName, Integer index, Object value) {
        if (value instanceof Map) {
            return this.index(indexName, index, (Map)value);
        }
        if (value instanceof List) {
            return this.index(indexName, index, (List)value);
        }
        return this.index(indexName, index, (String)value);
    }
}

