/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.api.execution;

import com.chutneytesting.engine.api.execution.StatusDto;
import com.chutneytesting.engine.api.execution.StepExecutionReportDto;
import com.chutneytesting.engine.domain.execution.report.Status;
import com.chutneytesting.engine.domain.execution.report.StepExecutionReport;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

class StepExecutionReportMapper {
    private StepExecutionReportMapper() {
    }

    static StepExecutionReportDto toDto(StepExecutionReport report) {
        return new StepExecutionReportDto(report.name, report.environment, report.startDate, report.duration, StatusMapper.toDto(report.status), report.information, report.errors, report.steps.stream().map(StepExecutionReportMapper::toDto).collect(Collectors.toList()), StepContextMapper.toDto(report.scenarioContext, report.evaluatedInputs, report.stepResults), report.type, report.targetName, report.targetUrl, report.strategy);
    }

    static class StatusMapper {
        StatusMapper() {
        }

        static StatusDto toDto(Status status) {
            return StatusDto.valueOf(status.name());
        }
    }

    static class StepContextMapper {
        StepContextMapper() {
        }

        static StepExecutionReportDto.StepContextDto toDto(Map<String, Object> scenarioContext, Map<String, Object> evaluatedInput, Map<String, Object> stepResults) {
            return new StepExecutionReportDto.StepContextDto(scenarioContext != null ? scenarioContext : Collections.EMPTY_MAP, evaluatedInput != null ? evaluatedInput : Collections.EMPTY_MAP, stepResults != null ? stepResults : Collections.EMPTY_MAP);
        }
    }
}

