/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class ActionDto {
    private String identifier;
    private boolean target;
    private List<InputsDto> inputs;

    public ActionDto(String identifier, boolean hasTarget, List<InputsDto> inputs) {
        this.identifier = identifier;
        this.target = hasTarget;
        this.inputs = inputs;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="target")
    boolean target() {
        return this.target;
    }

    public List<InputsDto> getInputs() {
        return this.inputs;
    }

    public static class InputsDto {
        private String name;
        private Class<?> type;

        public InputsDto(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InputsDto inputsDto = (InputsDto)o;
            return Objects.equals(this.name, inputsDto.name) && Objects.equals(this.type, inputsDto.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }

        public String toString() {
            return new StringJoiner(", ", InputsDto.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("type=" + this.type).toString();
        }
    }
}

