/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.engine.step;

import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.engine.domain.environment.TargetImpl;
import com.chutneytesting.engine.domain.execution.RxBus;
import com.chutneytesting.engine.domain.execution.ScenarioExecution;
import com.chutneytesting.engine.domain.execution.StepDefinition;
import com.chutneytesting.engine.domain.execution.engine.StepExecutor;
import com.chutneytesting.engine.domain.execution.engine.evaluation.EvaluationException;
import com.chutneytesting.engine.domain.execution.engine.evaluation.StepDataEvaluator;
import com.chutneytesting.engine.domain.execution.engine.scenario.ScenarioContext;
import com.chutneytesting.engine.domain.execution.engine.scenario.ScenarioContextImpl;
import com.chutneytesting.engine.domain.execution.engine.step.StepState;
import com.chutneytesting.engine.domain.execution.event.BeginStepExecutionEvent;
import com.chutneytesting.engine.domain.execution.event.EndStepExecutionEvent;
import com.chutneytesting.engine.domain.execution.event.PauseStepExecutionEvent;
import com.chutneytesting.engine.domain.execution.report.Status;
import com.chutneytesting.engine.domain.execution.report.StepExecutionReport;
import com.chutneytesting.engine.domain.execution.strategies.StepStrategyDefinition;
import com.chutneytesting.tools.Try;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Step {
    private static final Logger LOGGER = LoggerFactory.getLogger(Step.class);
    private final StepDefinition definition;
    private final StepState state;
    private final List<Step> steps;
    private Target target;
    private final StepExecutor executor;
    private final StepDataEvaluator dataEvaluator;
    private StepContext stepContext;

    public Step(StepDataEvaluator dataEvaluator, StepDefinition definition, StepExecutor executor, List<Step> steps) {
        this.dataEvaluator = dataEvaluator;
        this.definition = definition;
        this.target = definition.getTarget().orElse(TargetImpl.NONE);
        this.executor = executor;
        this.steps = steps;
        this.state = new StepState();
        this.stepContext = new StepContext();
    }

    public static Step nonExecutable(StepDefinition definition) {
        return new Step(null, definition, null, Collections.emptyList());
    }

    public Status execute(ScenarioExecution scenarioExecution, ScenarioContext scenarioContext) {
        return this.execute(scenarioExecution, scenarioContext, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status execute(ScenarioExecution scenarioExecution, ScenarioContext scenarioContext, Map<String, Object> localContext) {
        if (scenarioExecution.hasToPause()) {
            Instant startPauseInstant = Instant.now();
            this.pauseExecution(scenarioExecution);
            scenarioExecution.waitForRestart();
            this.state.resumeExecution();
            this.state.addInformation("Step pause from " + startPauseInstant + " to " + Instant.now());
        }
        if (scenarioExecution.hasToStop()) {
            this.stopExecution(scenarioExecution);
            return Status.STOPPED;
        }
        this.beginExecution(scenarioExecution);
        try {
            Map<String, Object> evaluationContext = this.buildEvaluationContext(scenarioContext, localContext);
            Map<String, Object> evaluatedInputs = this.definition.type.equals("final") ? this.definition.inputs() : Collections.unmodifiableMap(this.dataEvaluator.evaluateNamedDataWithContextVariables(this.definition.inputs(), evaluationContext));
            this.target = this.dataEvaluator.evaluateTarget(this.target, evaluationContext);
            Try.exec(() -> {
                this.stepContext = new StepContext(scenarioContext, localContext, evaluatedInputs);
                return this.stepContext;
            }).ifSuccess(stepContextExecuted -> {
                this.executor.execute(scenarioExecution, this.target, this);
                if (Status.SUCCESS.equals((Object)this.state.status())) {
                    this.executeStepValidations((StepContext)stepContextExecuted);
                }
                this.stepContext = stepContextExecuted.copy();
            }).ifFailed(this::failure);
        }
        catch (RuntimeException e) {
            this.failure(e);
            LOGGER.warn("Intercepted exception!", (Throwable)e);
        }
        finally {
            this.endExecution(scenarioExecution);
        }
        return this.state.status();
    }

    public void beginExecution(ScenarioExecution scenarioExecution) {
        this.state.beginExecution();
        RxBus.getInstance().post(new BeginStepExecutionEvent(scenarioExecution, this));
    }

    public void endExecution(ScenarioExecution scenarioExecution) {
        this.state.endExecution(this.isParentStep());
        RxBus.getInstance().post(new EndStepExecutionEvent(scenarioExecution, this));
    }

    public void stopExecution(ScenarioExecution scenarioExecution) {
        this.state.addInformation("Stop requested before executing this step");
        this.state.stopExecution();
        RxBus.getInstance().post(new EndStepExecutionEvent(scenarioExecution, this));
    }

    public void pauseExecution(ScenarioExecution scenarioExecution) {
        this.state.pauseExecution();
        RxBus.getInstance().post(new PauseStepExecutionEvent(scenarioExecution, this));
    }

    public Status status() {
        if (this.isParentStep()) {
            Status worstSubStepsStatus = Status.worst(this.subStepsStatus());
            if (Status.PAUSED.equals((Object)worstSubStepsStatus)) {
                return Status.PAUSED;
            }
            if (Status.RUNNING.equals((Object)this.state.status())) {
                return Status.RUNNING;
            }
            return worstSubStepsStatus;
        }
        return this.state.status();
    }

    private List<Status> subStepsStatus() {
        if (!this.isParentStep() || Status.FAILURE.equals((Object)this.state.status())) {
            return Lists.newArrayList((Object[])new Status[]{this.state.status()});
        }
        return this.steps.stream().map(Step::status).collect(Collectors.toList());
    }

    public void addInformation(String ... info) {
        this.state.addInformation(info);
    }

    public void addErrorMessage(String ... errors) {
        this.state.addErrors(errors);
    }

    public void failure(Throwable e) {
        this.failure(Optional.ofNullable(e.getMessage()).orElse(e.toString()));
    }

    public void failure(String ... message) {
        this.state.errorOccurred(message);
    }

    public void success(String ... message) {
        this.state.successOccurred(message);
    }

    public void resetExecution() {
        this.state.reset();
        this.steps.forEach(Step::resetExecution);
    }

    public void startWatch() {
        this.state.startWatch();
    }

    public void stopWatch() {
        this.state.stopWatch();
    }

    public Duration duration() {
        return this.state.duration();
    }

    public Instant startDate() {
        return this.state.startDate();
    }

    public List<String> informations() {
        return this.state.informations();
    }

    public List<String> errors() {
        return this.state.errors();
    }

    public Target target() {
        return this.target;
    }

    public StepDefinition definition() {
        return this.definition;
    }

    public Optional<StepStrategyDefinition> strategy() {
        return this.definition.getStrategy();
    }

    public String type() {
        return this.definition.type;
    }

    public List<Step> subSteps() {
        return this.steps;
    }

    public StepExecutor executor() {
        return this.executor;
    }

    public StepDataEvaluator dataEvaluator() {
        return this.dataEvaluator;
    }

    public boolean isParentStep() {
        return !this.steps.isEmpty();
    }

    public void updateContextFrom(StepExecutionReport remoteReport) {
        ActionExecutionResult.Status status = Status.SUCCESS.equals((Object)remoteReport.status) ? ActionExecutionResult.Status.Success : ActionExecutionResult.Status.Failure;
        this.updateContextWith(status, remoteReport.stepResults, Collections.emptyList(), Collections.emptyList());
    }

    public void updateContextFrom(ActionExecutionResult actionResult) {
        this.updateContextWith(actionResult.status, actionResult.outputs, Collections.emptyList(), Collections.emptyList());
    }

    private Map<String, Object> buildEvaluationContext(ScenarioContext scenarioContext, Map<String, Object> localContext) {
        HashMap<String, Object> evaluationContext = new HashMap<String, Object>();
        evaluationContext.putAll(scenarioContext);
        evaluationContext.putAll(localContext);
        evaluationContext.put("target", this.target);
        return evaluationContext;
    }

    private void updateContextWith(ActionExecutionResult.Status status, Map<String, Object> actionOutputs, List<String> information, List<String> errors) {
        if (status == ActionExecutionResult.Status.Success) {
            Try.exec(() -> {
                this.updateContextWithActionOutputs(actionOutputs);
                this.updateContextWithDefinitionOutputs();
                this.success(new String[0]);
                return null;
            }).ifFailed(e -> this.failure("Cannot evaluate outputs. - Exception: " + e.getClass() + " with message: \"" + e.getMessage() + "\""));
        } else {
            this.failure(Lists.newArrayList(errors).toArray(new String[errors.size()]));
        }
        this.addInformation(Lists.newArrayList(information).toArray(new String[information.size()]));
    }

    private void updateContextWithActionOutputs(Map<String, Object> actionOutputs) {
        this.stepContext.addStepOutputs(actionOutputs);
        this.stepContext.addScenarioContext(actionOutputs);
    }

    private void updateContextWithDefinitionOutputs() {
        Map<String, Object> evaluatedOutputs = this.dataEvaluator.evaluateNamedDataWithContextVariables(this.definition.outputs, this.stepContext.evaluationContext());
        this.stepContext.addStepOutputs(evaluatedOutputs);
        this.stepContext.addScenarioContext(evaluatedOutputs);
    }

    private void executeStepValidations(StepContext stepContext) {
        Try.exec(() -> {
            Map<String, Object> evaluatedValidations = this.dataEvaluator.evaluateNamedDataWithContextVariables(this.definition.validations, stepContext.evaluationContext());
            evaluatedValidations.forEach((k, v) -> {
                if (!((Boolean)v).booleanValue()) {
                    this.failure("Validation [" + k + " : " + this.definition.validations.get(k).toString() + "] : KO");
                } else {
                    this.state.addInformation("Validation [" + k + " : " + this.definition.validations.get(k).toString() + "] : OK");
                }
            });
            return null;
        }).ifFailed(e -> this.failure("Step validation failed. - Exception: " + e.getClass() + " with message: \"" + e.getMessage() + "\""));
    }

    public void addStepExecution(Step step) {
        this.steps.add(step);
    }

    public void addStepExecution(List<Step> steps) {
        steps.forEach(this::addStepExecution);
    }

    public Map<String, Object> getEvaluatedInputs() {
        return Collections.unmodifiableMap(this.stepContext.getEvaluatedInputs());
    }

    public Map<String, Object> getScenarioContext() {
        return this.stepContext.getScenarioContext().unmodifiable();
    }

    public Map<String, Object> getStepOutputs() {
        return Collections.unmodifiableMap(this.stepContext.getStepOutputs());
    }

    public void removeStepExecution() {
        this.steps.clear();
    }

    private static class StepContext {
        private final ScenarioContext scenarioContext;
        private final Map<String, Object> localContext;
        private final Map<String, Object> evaluatedInputs;
        private final Map<String, Object> stepOutputs;

        private StepContext() {
            this(new ScenarioContextImpl(), new LinkedHashMap<String, Object>(), new LinkedHashMap<String, Object>());
        }

        private StepContext(ScenarioContext scenarioContext, Map<String, Object> localContext, Map<String, Object> evaluatedInputs) throws EvaluationException {
            this(scenarioContext, localContext, evaluatedInputs, new LinkedHashMap<String, Object>());
        }

        private StepContext(ScenarioContext scenarioContext, Map<String, Object> localContext, Map<String, Object> evaluatedInputs, Map<String, Object> stepOutputs) {
            this.scenarioContext = scenarioContext;
            this.localContext = localContext;
            this.evaluatedInputs = evaluatedInputs;
            this.stepOutputs = stepOutputs;
        }

        private Map<String, Object> evaluationContext() {
            LinkedHashMap allResults = Maps.newLinkedHashMap((Map)this.scenarioContext);
            allResults.putAll(this.localContext);
            allResults.putAll(this.stepOutputs);
            return allResults;
        }

        private ScenarioContext getScenarioContext() {
            return this.scenarioContext;
        }

        private Map<String, Object> getEvaluatedInputs() {
            return Optional.ofNullable(this.evaluatedInputs).orElse(Collections.emptyMap());
        }

        @SafeVarargs
        private void addLocalContext(Map.Entry<String, Object> ... entries) {
            this.addLocalContext(Map.ofEntries(entries));
        }

        private void addLocalContext(Map<String, Object> localContext) {
            if (localContext != null) {
                this.localContext.putAll(localContext);
            }
        }

        private void addStepOutputs(Map<String, Object> stepOutputs) {
            if (stepOutputs != null) {
                this.stepOutputs.putAll(stepOutputs);
            }
        }

        private void addScenarioContext(Map<String, Object> context) {
            if (context != null) {
                this.scenarioContext.putAll(context);
            }
        }

        private Map<String, Object> getStepOutputs() {
            return Optional.ofNullable(this.stepOutputs).orElse(Collections.emptyMap());
        }

        private StepContext copy() {
            return new StepContext(this.scenarioContext.unmodifiable(), Collections.unmodifiableMap(this.localContext), Collections.unmodifiableMap(this.evaluatedInputs), Collections.unmodifiableMap(this.stepOutputs));
        }
    }
}

