/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.infra;

import com.chutneytesting.action.domain.ActionTemplate;
import com.chutneytesting.action.domain.ActionTemplateLoader;
import com.chutneytesting.action.domain.ActionTemplateParser;
import com.chutneytesting.action.domain.ParsingError;
import com.chutneytesting.action.domain.ResultOrError;
import com.chutneytesting.tools.loader.ExtensionLoaders;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultActionTemplateLoader<T>
implements ActionTemplateLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultActionTemplateLoader.class);
    private final String extensionFileName;
    private final Class<T> actionInterface;
    private final ActionTemplateParser<T> actionTemplateParser;

    public DefaultActionTemplateLoader(String extensionFileName, Class<T> actionInterface, ActionTemplateParser<T> actionTemplateParser) {
        this.extensionFileName = extensionFileName;
        this.actionInterface = actionInterface;
        this.actionTemplateParser = actionTemplateParser;
    }

    @Override
    public List<ActionTemplate> load() {
        return this.loadClasses().map(this.actionTemplateParser::parse).peek(this::warnIfParsingError).filter(ResultOrError::isOk).map(parsingResult -> (ActionTemplate)parsingResult.result()).collect(Collectors.toList());
    }

    private Stream<Class<? extends T>> loadClasses() {
        return ExtensionLoaders.classpathToClass((String)("META-INF/extension/" + this.extensionFileName)).load().stream().peek(this::warnIfNotAction).filter(this::isAction).map(clazz -> clazz);
    }

    private void warnIfNotAction(Class<?> clazz) {
        if (!this.isAction(clazz)) {
            LOGGER.warn("Unable to load " + clazz.getName() + ": not a " + this.actionInterface.getName());
        }
    }

    private boolean isAction(Class<?> clazz) {
        return this.actionInterface.isAssignableFrom(clazz);
    }

    private void warnIfParsingError(ResultOrError<ActionTemplate, ParsingError> parsingResult) {
        if (parsingResult.isError()) {
            LOGGER.warn("Unable to parse Action[" + parsingResult.error().actionClass().getName() + "]: " + parsingResult.error().errorMessage());
        }
    }
}

