/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.strategies;

import com.chutneytesting.action.spi.time.Duration;
import com.chutneytesting.engine.domain.execution.ScenarioExecution;
import com.chutneytesting.engine.domain.execution.engine.scenario.ScenarioContext;
import com.chutneytesting.engine.domain.execution.engine.step.Step;
import com.chutneytesting.engine.domain.execution.report.Status;
import com.chutneytesting.engine.domain.execution.strategies.DefaultStepExecutionStrategy;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategies;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategy;
import com.chutneytesting.engine.domain.execution.strategies.StepStrategyDefinition;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class RetryWithTimeOutStrategy
implements StepExecutionStrategy {
    private static final String TYPE = "retry-with-timeout";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Status execute(ScenarioExecution scenarioExecution, Step step, ScenarioContext scenarioContext, Map<String, Object> localContext, StepExecutionStrategies strategies) throws IllegalStateException {
        if (step.strategy().isEmpty()) {
            throw new IllegalArgumentException("Should not have strategy definition empty for retry strategy");
        }
        StepStrategyDefinition strategyDefinition = step.strategy().get();
        String timeOut = strategyDefinition.strategyProperties.getProperty("timeOut", String.class);
        String retryDelay = strategyDefinition.strategyProperties.getProperty("retryDelay", String.class);
        if (timeOut == null) {
            throw new IllegalStateException("Undefined parameter 'timeOut'");
        }
        if (retryDelay == null) {
            throw new IllegalStateException("Undefined parameter 'retryDelay'");
        }
        Long timeOutMs = this.toMilliSeconds(timeOut);
        Long retryDelayMs = this.toMilliSeconds(retryDelay);
        Long timeLeft = timeOutMs;
        Status st = Status.NOT_EXECUTED;
        int tries = 1;
        ArrayList<String> lastErrors = new ArrayList<String>();
        do {
            Long tryStartTime = System.currentTimeMillis();
            step.addInformation("Retry strategy definition : [timeOut " + timeOut + "] [delay " + retryDelay + "]");
            step.addInformation("Try number : " + tries++);
            st = this.executeAll(scenarioExecution, step, scenarioContext, localContext, strategies);
            if (st == Status.FAILURE) {
                try {
                    step.startWatch();
                    TimeUnit.MILLISECONDS.sleep(retryDelayMs);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Sleeping between executions have been interrupted", e);
                }
                finally {
                    step.stopWatch();
                }
            } else {
                if (lastErrors.isEmpty()) break;
                step.addErrorMessage("Error(s) on last step execution:");
                lastErrors.forEach(xva$0 -> step.addErrorMessage((String)xva$0));
                break;
            }
            timeLeft = timeLeft - (System.currentTimeMillis() - tryStartTime);
            if (timeLeft <= 0L) continue;
            lastErrors.clear();
            lastErrors.addAll(step.errors());
            step.resetExecution();
        } while (timeLeft > 0L);
        return st;
    }

    private Status executeAll(ScenarioExecution scenarioExecution, Step step, ScenarioContext scenarioContext, Map<String, Object> localContext, StepExecutionStrategies strategies) {
        Status st = DefaultStepExecutionStrategy.instance.execute(scenarioExecution, step, scenarioContext, localContext, strategies);
        if (st == Status.FAILURE) {
            if (scenarioExecution.hasToStop()) {
                step.stopExecution(scenarioExecution);
                return Status.STOPPED;
            }
            return st;
        }
        return Status.SUCCESS;
    }

    private long toMilliSeconds(String duration) {
        double durationInMS = Duration.parse((String)duration).toMilliseconds();
        return Math.round(durationInMS);
    }
}

