/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.report;

import com.google.common.collect.Ordering;
import java.util.List;
import java.util.Objects;

public enum Status {
    SUCCESS,
    WARN,
    FAILURE,
    NOT_EXECUTED,
    STOPPED,
    PAUSED,
    RUNNING,
    EXECUTED;

    private static final Ordering<Status> EXECUTION_STATUS_STATUS_ORDERING;

    public static Status worst(List<Status> severalStatus) {
        List<Status> notExecutedStatus;
        Status reducedStatus = severalStatus.stream().filter(Objects::nonNull).reduce(SUCCESS, (arg_0, arg_1) -> EXECUTION_STATUS_STATUS_ORDERING.min(arg_0, arg_1));
        if (reducedStatus.equals((Object)NOT_EXECUTED) && !(notExecutedStatus = severalStatus.stream().filter(s -> !s.equals((Object)NOT_EXECUTED)).toList()).isEmpty()) {
            return RUNNING;
        }
        return reducedStatus;
    }

    static {
        EXECUTION_STATUS_STATUS_ORDERING = Ordering.explicit((Object)((Object)EXECUTED), (Object[])new Status[]{PAUSED, RUNNING, STOPPED, FAILURE, WARN, NOT_EXECUTED, SUCCESS});
    }

    public static interface HavingStatus {
        public Status getStatus();
    }
}

