/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting;

import com.chutneytesting.action.spi.injectable.ActionsConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineActionsConfiguration
implements ActionsConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineActionsConfiguration.class);
    private final Map<String, String> configuration = new HashMap<String, String>();

    public EngineActionsConfiguration(Map<String, String> configuration) {
        this.configuration.putAll(configuration);
    }

    public String getString(String key) {
        return this.configuration.get(key);
    }

    public String getString(String key, String defaultValue) {
        return Optional.ofNullable(this.getString(key)).orElse(defaultValue);
    }

    public Integer getInteger(String key) {
        String value = this.configuration.get(key);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException exception) {
                LOGGER.error("Cannot parse [{}] to Integer", (Object)value);
            }
        }
        return null;
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return Optional.ofNullable(this.getInteger(key)).orElse(defaultValue);
    }
}

