/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.delegation;

import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.engine.domain.delegation.CannotDelegateException;
import com.chutneytesting.engine.domain.delegation.DelegationClient;
import com.chutneytesting.engine.domain.delegation.NamedHostAndPort;
import com.chutneytesting.engine.domain.execution.ScenarioExecution;
import com.chutneytesting.engine.domain.execution.engine.StepExecutor;
import com.chutneytesting.engine.domain.execution.engine.step.Step;
import com.chutneytesting.engine.domain.execution.engine.step.StepContext;
import com.chutneytesting.engine.domain.execution.report.Status;
import com.chutneytesting.engine.domain.execution.report.StepExecutionReport;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public class RemoteStepExecutor
implements StepExecutor {
    private final DelegationClient delegationClient;
    private final NamedHostAndPort agentInfo;

    public RemoteStepExecutor(DelegationClient delegationClient, NamedHostAndPort agentInfo) {
        this.delegationClient = delegationClient;
        this.agentInfo = agentInfo;
    }

    @Override
    public void execute(ScenarioExecution scenarioExecution, StepContext localStepContext, Target target, Step step) {
        try {
            StepExecutionReport remoteReport = this.delegationClient.handDown(step.definition(), this.agentInfo);
            this.guardFromIllegalReport(remoteReport);
            this.updateLocalContext(step, localStepContext, remoteReport);
        }
        catch (CannotDelegateException e) {
            step.failure(e);
        }
    }

    private void guardFromIllegalReport(StepExecutionReport remoteReport) {
        Assert.notNull(remoteReport.evaluatedInputs, (String)"EvaluatedInputs are null after delegation. 0_o !");
        Assert.notNull(remoteReport.scenarioContext, (String)"ScenarioContext is null after delegation. 0_o !");
        Assert.notNull(remoteReport.stepResults, (String)"StepResults are null after delegation. 0_o !");
        Assert.notNull((Object)((Object)remoteReport.status), (String)"Status is null after delegation. 0_o !");
        Assert.notNull(remoteReport.information, (String)"Information are null after delegation. 0_o !");
        Assert.notNull(remoteReport.errors, (String)"Errors are null after delegation. 0_o !");
    }

    private void updateLocalContext(Step step, StepContext localStepContext, StepExecutionReport remoteReport) {
        this.updateWith(localStepContext, remoteReport.scenarioContext, remoteReport.stepResults);
        this.propagateInformation(step, remoteReport.information);
        this.propagateStatus(step, remoteReport.status, remoteReport.errors);
    }

    private void propagateInformation(Step step, List<String> information) {
        step.addInformation(Lists.newArrayList(information).toArray(new String[information.size()]));
    }

    private void propagateStatus(Step step, Status reportStatus, List<String> errors) {
        if (reportStatus.equals((Object)Status.FAILURE)) {
            step.failure(Lists.newArrayList(errors).toArray(new String[errors.size()]));
        } else {
            step.success(new String[0]);
        }
    }

    private void updateWith(StepContext localStepContext, Map<String, Object> scenarioContext, Map<String, Object> stepResults) {
        if (scenarioContext != null) {
            localStepContext.addScenarioContext(scenarioContext);
        }
        if (stepResults != null) {
            localStepContext.addStepOutputs(stepResults);
        }
    }
}

