/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.api;

import com.chutneytesting.action.api.ActionDto;
import com.chutneytesting.action.api.ActionNotFoundException;
import com.chutneytesting.action.api.EmbeddedActionEngine;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/action/v1"})
@CrossOrigin(origins={"*"})
public class ActionController {
    static final String BASE_URL = "/api/action/v1";
    private final EmbeddedActionEngine embeddedActionEngine;

    public ActionController(EmbeddedActionEngine embeddedActionEngine) {
        this.embeddedActionEngine = embeddedActionEngine;
    }

    @PreAuthorize(value="hasAuthority('COMPONENT_READ')")
    @GetMapping(produces={"application/json"})
    public List<ActionDto> allActions() {
        return this.embeddedActionEngine.getAllActions();
    }

    @PreAuthorize(value="hasAuthority('COMPONENT_READ')")
    @GetMapping(path={"/{actionId}"}, produces={"application/json"})
    public ActionDto byActionId(@PathVariable String actionId) {
        return this.embeddedActionEngine.getAction(actionId).orElseThrow(ActionNotFoundException::new);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="The action id could not be found")
    @ExceptionHandler(value={ActionNotFoundException.class})
    void notFoundAction() {
    }
}

