/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.engine;

import com.chutneytesting.action.spi.FinallyAction;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.engine.domain.delegation.DelegationService;
import com.chutneytesting.engine.domain.execution.ExecutionEngine;
import com.chutneytesting.engine.domain.execution.RxBus;
import com.chutneytesting.engine.domain.execution.ScenarioExecution;
import com.chutneytesting.engine.domain.execution.StepDefinition;
import com.chutneytesting.engine.domain.execution.engine.FinallyActionMapper;
import com.chutneytesting.engine.domain.execution.engine.StepExecutor;
import com.chutneytesting.engine.domain.execution.engine.evaluation.StepDataEvaluator;
import com.chutneytesting.engine.domain.execution.engine.scenario.ScenarioContext;
import com.chutneytesting.engine.domain.execution.engine.scenario.ScenarioContextImpl;
import com.chutneytesting.engine.domain.execution.engine.step.Step;
import com.chutneytesting.engine.domain.execution.event.EndScenarioExecutionEvent;
import com.chutneytesting.engine.domain.execution.event.StartScenarioExecutionEvent;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategies;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategy;
import com.chutneytesting.engine.domain.execution.strategies.StepStrategyDefinition;
import com.chutneytesting.engine.domain.execution.strategies.StrategyProperties;
import com.chutneytesting.engine.domain.report.Reporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutionEngine
implements ExecutionEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutionEngine.class);
    private final Executor actionExecutor;
    private final StepDataEvaluator dataEvaluator;
    private final StepExecutionStrategies stepExecutionStrategies;
    private final DelegationService delegationService;
    private final Reporter reporter;

    public DefaultExecutionEngine(StepDataEvaluator dataEvaluator, StepExecutionStrategies stepExecutionStrategies, DelegationService delegationService, Reporter reporter, Executor actionExecutor) {
        this.dataEvaluator = dataEvaluator;
        this.stepExecutionStrategies = stepExecutionStrategies != null ? stepExecutionStrategies : new StepExecutionStrategies();
        this.delegationService = delegationService;
        this.reporter = reporter;
        this.actionExecutor = actionExecutor;
    }

    @Override
    public Long execute(StepDefinition stepDefinition, ScenarioExecution execution) {
        AtomicReference<Step> rootStep = new AtomicReference<Step>(Step.nonExecutable(stepDefinition));
        this.reporter.createPublisher(execution.executionId, rootStep.get());
        this.actionExecutor.execute(() -> {
            ScenarioContextImpl scenarioContext = new ScenarioContextImpl();
            try {
                try {
                    rootStep.set(this.buildStep(stepDefinition));
                    RxBus.getInstance().post(new StartScenarioExecutionEvent(execution, (Step)rootStep.get()));
                    StepExecutionStrategy strategy = this.stepExecutionStrategies.buildStrategyFrom((Step)rootStep.get());
                    strategy.execute(execution, (Step)rootStep.get(), scenarioContext, this.stepExecutionStrategies);
                }
                catch (LinkageError | RuntimeException e) {
                    ((Step)rootStep.get()).failure(e);
                    LOGGER.warn("Intercepted exception in root step execution !", e);
                }
                this.executeFinallyActions(execution, rootStep, scenarioContext);
            }
            finally {
                RxBus.getInstance().post(new EndScenarioExecutionEvent(execution, (Step)rootStep.get()));
            }
        });
        return execution.executionId;
    }

    private Optional<Step> initFinalRootStep(AtomicReference<Step> rootStep, List<FinallyAction> finallyActionsSnapshot) {
        try {
            String environment = rootStep.get().definition().environment;
            Pair finalStepsWithDefinitions = finallyActionsSnapshot.stream().map(fa -> {
                StepDefinition definition = new FinallyActionMapper().toStepDefinition((FinallyAction)fa, environment);
                return Pair.of(Collections.singletonList(definition), Collections.singletonList(this.buildStep(definition)));
            }).reduce(Pair.of(new ArrayList(), new ArrayList()), (p1, p2) -> {
                ((List)p1.getLeft()).addAll((Collection)p2.getLeft());
                ((List)p1.getRight()).addAll((Collection)p2.getRight());
                return p1;
            });
            StepDefinition finalRootStepDefinition = new StepDefinition("TearDown", null, "", new StepStrategyDefinition("soft-assert", new StrategyProperties()), Collections.emptyMap(), (List)finalStepsWithDefinitions.getLeft(), Collections.emptyMap(), Collections.emptyMap(), environment);
            return Optional.of(new Step(this.dataEvaluator, finalRootStepDefinition, this.delegationService.findExecutor(Optional.empty()), (List)finalStepsWithDefinitions.getRight()));
        }
        catch (RuntimeException e) {
            rootStep.get().failure(e);
            LOGGER.warn("Cannot init final root step !", (Throwable)e);
            return Optional.empty();
        }
    }

    private void executeFinallyActions(ScenarioExecution execution, AtomicReference<Step> rootStep, ScenarioContext scenarioContext) {
        if (!execution.finallyActions().isEmpty()) {
            ArrayList<FinallyAction> finallyActionsSnapshot = new ArrayList<FinallyAction>(execution.finallyActions());
            Optional<Step> finalRootStep = this.initFinalRootStep(rootStep, finallyActionsSnapshot);
            finalRootStep.ifPresent(frs -> {
                ((Step)rootStep.get()).addStepExecution((Step)frs);
                execution.initFinallyActionExecution();
                try {
                    StepExecutionStrategy strategy = this.stepExecutionStrategies.buildStrategyFrom((Step)frs);
                    strategy.execute(execution, (Step)frs, scenarioContext, this.stepExecutionStrategies);
                }
                catch (RuntimeException e) {
                    frs.failure(e);
                    LOGGER.warn("Teardown did not finish properly !", (Throwable)e);
                }
            });
        }
    }

    private Step buildStep(StepDefinition definition) {
        LOGGER.debug("Build : " + definition);
        Optional<Target> target = definition.getTarget();
        StepExecutor executor = this.delegationService.findExecutor(target);
        List<Step> steps = definition.steps.stream().map(this::buildStep).collect(Collectors.toList());
        return new Step(this.dataEvaluator, definition, executor, steps);
    }
}

