/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.api;

import com.chutneytesting.task.api.EmbeddedTaskEngine;
import com.chutneytesting.task.api.TaskDto;
import com.chutneytesting.task.api.TaskNotFoundException;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/task/v1"})
@CrossOrigin(origins={"*"})
public class TaskController {
    static final String BASE_URL = "/api/task/v1";
    private final EmbeddedTaskEngine embeddedTaskEngine;

    public TaskController(EmbeddedTaskEngine embeddedTaskEngine) {
        this.embeddedTaskEngine = embeddedTaskEngine;
    }

    @PreAuthorize(value="hasAuthority('COMPONENT_READ')")
    @GetMapping(produces={"application/json"})
    public List<TaskDto> allTasks() {
        return this.embeddedTaskEngine.getAllTasks();
    }

    @PreAuthorize(value="hasAuthority('COMPONENT_READ')")
    @GetMapping(path={"/{taskId}"}, produces={"application/json"})
    public TaskDto byTaskId(@PathVariable String taskId) {
        return this.embeddedTaskEngine.getTask(taskId).orElseThrow(TaskNotFoundException::new);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="The task id could not be found")
    @ExceptionHandler(value={TaskNotFoundException.class})
    void notFoundTask() {
    }
}

