/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.engine.evaluation;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class Strings {
    private static final Map<String, Pattern> PATTERN_CACHE = new HashMap<String, Pattern>();

    private Strings() {
    }

    public static String replaceExpressions(String template, Function<String, Object> evaluator, String prefix, String suffix, String escape) {
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Strings.cachePattern("(" + Strings.escapeForRegex(escape) + ")?" + Strings.escapeForRegex(prefix) + "(.*?)" + Strings.escapeForRegex(suffix));
        Matcher matcher = pattern.matcher(template);
        while (matcher.find()) {
            String escapeMatch = matcher.group(1);
            String key = matcher.group(2);
            if (escapeMatch == null) {
                Object o = evaluator.apply(key);
                if (o == null) continue;
                String replacement = Matcher.quoteReplacement(String.valueOf(o));
                matcher.appendReplacement(sb, replacement);
                continue;
            }
            String replacement = Matcher.quoteReplacement(prefix + key + suffix);
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static Object replaceExpression(String template, Function<String, Object> transformer, String prefix, String suffix, String escape) {
        Pattern pattern = Strings.cachePattern("^(" + Strings.escapeForRegex(escape) + ")?" + Strings.escapeForRegex(prefix) + "(.*?)" + Strings.escapeForRegex(suffix) + "$");
        Matcher matcher = pattern.matcher(template.trim());
        if (matcher.matches()) {
            String escapeMatch = matcher.group(1);
            String key = matcher.group(2);
            if (escapeMatch == null) {
                return transformer.apply(key);
            }
            return prefix + key + suffix;
        }
        return template;
    }

    public static String escapeForRegex(String literal) {
        return literal.replaceAll("\\\\", Matcher.quoteReplacement("\\\\")).replaceAll("\\$", Matcher.quoteReplacement("\\$")).replaceAll("\\{", Matcher.quoteReplacement("\\{")).replaceAll("\\}", Matcher.quoteReplacement("\\}"));
    }

    private static Pattern cachePattern(String pattern) {
        return Optional.ofNullable(PATTERN_CACHE.get(pattern)).orElseGet(() -> {
            Pattern compiledPattern = Pattern.compile(pattern, 32);
            PATTERN_CACHE.put(pattern, compiledPattern);
            return compiledPattern;
        });
    }
}

