/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.api.execution;

import com.chutneytesting.engine.api.execution.TargetExecutionDto;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StepDefinitionDto {
    public final String name;
    private final TargetExecutionDto target;
    public final String type;
    public final Map<String, Object> inputs;
    public final List<StepDefinitionDto> steps;
    public final Map<String, Object> outputs;
    public final Map<String, Object> validations;
    public final StepStrategyDefinitionDto strategy;

    public StepDefinitionDto(String name, TargetExecutionDto target, String type, StepStrategyDefinitionDto strategy, Map<String, Object> inputs, List<StepDefinitionDto> steps, Map<String, Object> outputs, Map<String, Object> validations) {
        this.name = name;
        this.target = target;
        this.type = type;
        this.strategy = strategy;
        this.inputs = inputs != null ? Collections.unmodifiableMap(inputs) : Collections.emptyMap();
        this.steps = steps != null ? Collections.unmodifiableList(steps) : Collections.emptyList();
        this.outputs = outputs != null ? Collections.unmodifiableMap(outputs) : Collections.emptyMap();
        this.validations = validations != null ? Collections.unmodifiableMap(validations) : Collections.emptyMap();
    }

    public Optional<TargetExecutionDto> getTarget() {
        return Optional.ofNullable(this.target);
    }

    public String toString() {
        return "StepDefinition{name='" + this.name + "', type='" + this.type + "'}";
    }

    public static class StrategyPropertiesDto
    extends HashMap<String, Object> {
        public StrategyPropertiesDto() {
        }

        public StrategyPropertiesDto(Map<String, Object> data) {
            super(data);
        }

        public <T> T getProperty(String key, Class<T> type) {
            return type.cast(this.get(key));
        }

        public StrategyPropertiesDto setProperty(String key, Object value) {
            this.put(key, value);
            return this;
        }
    }

    public static class StepStrategyDefinitionDto {
        public final String type;
        public final StrategyPropertiesDto strategyProperties;

        public StepStrategyDefinitionDto(String type, StrategyPropertiesDto strategyProperties) {
            this.type = type;
            this.strategyProperties = strategyProperties;
        }
    }
}

