/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.domain.parameter;

import com.chutneytesting.task.domain.parameter.AnnotationSet;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;

public class Parameter {
    private final String name;
    private final AnnotationSet annotations;
    private final Class<?> rawType;

    private Parameter(String name, AnnotationSet annotations, Class<?> rawType) {
        this.name = name;
        this.annotations = annotations;
        this.rawType = rawType;
    }

    public AnnotationSet annotations() {
        return this.annotations;
    }

    public Class<?> rawType() {
        return this.rawType;
    }

    public String toString() {
        return "Parameter[name=" + this.name + ", rawType=" + this.rawType + "]";
    }

    public static Parameter fromJavaParameter(java.lang.reflect.Parameter parameter) {
        String name = Optional.of(parameter.getName()).filter(s -> parameter.isNamePresent()).orElse("<no name>");
        LinkedHashSet<Annotation> annotations = new LinkedHashSet<Annotation>(Arrays.asList(parameter.getDeclaredAnnotations()));
        return new Parameter(name, new AnnotationSet(annotations), parameter.getType());
    }
}

