/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.api;

import com.chutneytesting.task.api.TaskDto;
import com.chutneytesting.task.domain.TaskTemplate;
import com.chutneytesting.task.domain.parameter.Parameter;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Target;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TaskTemplateMapper {
    private TaskTemplateMapper() {
    }

    public static TaskDto toDto(TaskTemplate taskTemplate) {
        return new TaskDto(taskTemplate.identifier(), TaskTemplateMapper.hasTarget(taskTemplate), TaskTemplateMapper.toInputsDto(taskTemplate));
    }

    private static boolean hasTarget(TaskTemplate taskTemplate) {
        return taskTemplate.parameters().stream().anyMatch(p -> p.rawType().equals(Target.class));
    }

    private static List<TaskDto.InputsDto> toInputsDto(TaskTemplate taskTemplate) {
        Map<Boolean, List<Parameter>> parametersMap = taskTemplate.parameters().stream().filter(parameter -> parameter.annotations().optional(Input.class).isPresent()).collect(Collectors.partitioningBy(TaskTemplateMapper::isSimpleType));
        return Stream.concat(parametersMap.get(true).stream().map(TaskTemplateMapper::simpleParameterToInputsDto), parametersMap.get(false).stream().map(TaskTemplateMapper::complexParameterToInputsDto).flatMap(Collection::stream)).collect(Collectors.toList());
    }

    private static TaskDto.InputsDto simpleParameterToInputsDto(Parameter parameter) {
        return new TaskDto.InputsDto(parameter.annotations().get(Input.class).value(), parameter.rawType());
    }

    private static List<TaskDto.InputsDto> complexParameterToInputsDto(Parameter parameter) {
        Constructor<?> constructor;
        List<TaskDto.InputsDto> result;
        Constructor<?>[] constructors = parameter.rawType().getConstructors();
        if (constructors.length == 1 && !(result = Arrays.stream((constructor = constructors[0]).getParameters()).map(Parameter::fromJavaParameter).filter(p -> p.annotations().optional(Input.class).isPresent()).map(p -> new TaskDto.InputsDto(p.annotations().get(Input.class).value(), p.rawType())).collect(Collectors.toList())).isEmpty()) {
            return result;
        }
        return Collections.singletonList(TaskTemplateMapper.simpleParameterToInputsDto(parameter));
    }

    private static boolean isSimpleType(Parameter parameter) {
        Class<?> rawType = parameter.rawType();
        return rawType.isPrimitive() || rawType.equals(String.class) || rawType.equals(Object.class);
    }
}

