/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.environment;

import com.chutneytesting.engine.domain.delegation.NamedHostAndPort;
import com.chutneytesting.task.spi.injectable.Target;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TargetImpl
implements Target {
    public static final TargetImpl NONE = TargetImpl.builder().build();
    public final String name;
    public final URI uri;
    public final Map<String, String> properties;
    public final List<NamedHostAndPort> agents;

    private TargetImpl(String name, String url, Map<String, String> properties, List<NamedHostAndPort> agents) {
        this.name = name;
        this.uri = this.uriFrom(url);
        this.properties = properties;
        this.agents = agents;
    }

    public static TargetBuilder builder() {
        return new TargetBuilder();
    }

    public String name() {
        return this.name;
    }

    public URI uri() {
        return this.uri;
    }

    public Optional<String> property(String key) {
        return Optional.ofNullable(this.properties.get(key));
    }

    public Map<String, String> prefixedProperties(String prefix, boolean cutPrefix) {
        return this.properties.entrySet().stream().filter(e -> e.getKey() != null).filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(cutPrefix ? prefix.length() : 0), Map.Entry::getValue));
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    private URI uriFrom(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class TargetBuilder {
        private String name;
        private String url;
        private Map<String, String> properties;
        private List<NamedHostAndPort> agents;

        private TargetBuilder() {
        }

        public TargetImpl build() {
            return new TargetImpl(Optional.ofNullable(this.name).orElse(""), Optional.ofNullable(this.url).orElse(""), Optional.ofNullable(this.properties).orElse(Collections.emptyMap()), Optional.ofNullable(this.agents).orElse(Collections.emptyList()));
        }

        public TargetBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public TargetBuilder withUrl(String url) {
            this.url = url;
            return this;
        }

        public TargetBuilder withProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public TargetBuilder copyOf(TargetImpl target) {
            this.name = target.name;
            this.url = target.uri().toString();
            this.properties = target.properties;
            this.agents = target.agents;
            return this;
        }

        public TargetBuilder withAgents(List<NamedHostAndPort> agents) {
            this.agents = agents;
            return this;
        }
    }
}

