/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.domain;

import com.chutneytesting.task.domain.TaskInstantiationFailureException;
import com.chutneytesting.task.domain.TaskTemplate;
import com.chutneytesting.task.domain.parameter.Parameter;
import com.chutneytesting.task.domain.parameter.ParameterResolver;
import com.chutneytesting.task.spi.Task;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class TaskTemplateV2
implements TaskTemplate {
    private final String identifier;
    private final Class<? extends Task> implementationClass;
    private final Constructor<? extends Task> constructor;
    private final List<Parameter> parameters;

    public TaskTemplateV2(String identifier, Class<? extends Task> implementationClass, Constructor<? extends Task> constructor, List<Parameter> parameters) {
        this.identifier = identifier;
        this.implementationClass = implementationClass;
        this.constructor = constructor;
        this.parameters = parameters;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    public Class<? extends Task> implementationClass() {
        return this.implementationClass;
    }

    @Override
    public Set<Parameter> parameters() {
        return new LinkedHashSet<Parameter>(this.parameters);
    }

    @Override
    public Task create(List<ParameterResolver> parameterResolvers) {
        Object[] parameterValues = this.parameters.stream().map(p -> this.resolveParameter(parameterResolvers, (Parameter)p)).toArray(Object[]::new);
        try {
            return this.constructor.newInstance(parameterValues);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new TaskInstantiationFailureException(this.identifier, e);
        }
    }
}

