/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.environment;

import com.chutneytesting.engine.domain.delegation.NamedHostAndPort;
import com.chutneytesting.engine.domain.environment.SecurityInfoImpl;
import com.chutneytesting.task.spi.injectable.SecurityInfo;
import com.chutneytesting.task.spi.injectable.Target;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TargetImpl
implements Target {
    public static final Target NONE = TargetImpl.builder().build();
    public final String name;
    public final String url;
    public final URI uri;
    public final Map<String, String> properties;
    public final SecurityInfoImpl security;
    public final List<NamedHostAndPort> agents;

    private TargetImpl(String name, String url, Map<String, String> properties, SecurityInfoImpl security, List<NamedHostAndPort> agents) {
        this.name = name;
        this.url = url;
        this.uri = this.uriFrom(url);
        this.properties = properties;
        this.security = security;
        this.agents = agents;
    }

    public static TargetBuilder builder() {
        return new TargetBuilder();
    }

    public String name() {
        return this.name;
    }

    public String url() {
        return this.url;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public SecurityInfo security() {
        return this.security;
    }

    public URI uri() {
        return this.uri;
    }

    private URI uriFrom(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class TargetBuilder {
        private String name;
        private String url;
        private Map<String, String> properties;
        private List<NamedHostAndPort> agents;
        private SecurityInfoImpl security;

        private TargetBuilder() {
        }

        public TargetImpl build() {
            return new TargetImpl(Optional.ofNullable(this.name).orElse(""), Optional.ofNullable(this.url).orElse(""), Optional.ofNullable(this.properties).orElse(Collections.emptyMap()), Optional.ofNullable(this.security).orElse(SecurityInfoImpl.builder().build()), Optional.ofNullable(this.agents).orElse(Collections.emptyList()));
        }

        public TargetBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public TargetBuilder withUrl(String url) {
            this.url = url;
            return this;
        }

        public TargetBuilder withProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public TargetBuilder copyOf(TargetImpl target) {
            this.name = target.name;
            this.url = target.url;
            this.properties = target.properties;
            this.agents = target.agents;
            this.security = target.security;
            return this;
        }

        public TargetBuilder withSecurity(SecurityInfoImpl securityInfo) {
            this.security = securityInfo;
            return this;
        }

        public TargetBuilder withAgents(List<NamedHostAndPort> agents) {
            this.agents = agents;
            return this;
        }
    }
}

