/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.api.execution;

import com.chutneytesting.engine.api.execution.ExecutionRequestDto;
import com.chutneytesting.engine.api.execution.StepDefinitionMapper;
import com.chutneytesting.engine.api.execution.StepExecutionReportDto;
import com.chutneytesting.engine.api.execution.StepExecutionReportMapper;
import com.chutneytesting.engine.api.execution.TestEngine;
import com.chutneytesting.engine.domain.execution.ExecutionEngine;
import com.chutneytesting.engine.domain.execution.ExecutionManager;
import com.chutneytesting.engine.domain.execution.ScenarioExecution;
import com.chutneytesting.engine.domain.execution.StepDefinition;
import com.chutneytesting.engine.domain.report.Reporter;
import com.chutneytesting.task.spi.injectable.TasksConfiguration;
import io.reactivex.Observable;

public final class EmbeddedTestEngine
implements TestEngine {
    private final ExecutionEngine engine;
    private final Reporter reporter;
    private final ExecutionManager executionManager;
    private final TasksConfiguration tasksConfiguration;

    public EmbeddedTestEngine(ExecutionEngine engine, Reporter reporter, ExecutionManager executionManager, TasksConfiguration tasksConfiguration) {
        this.engine = engine;
        this.reporter = reporter;
        this.executionManager = executionManager;
        this.tasksConfiguration = tasksConfiguration;
    }

    @Override
    public StepExecutionReportDto execute(ExecutionRequestDto request) {
        Long executionId = this.executeAsync(request);
        return (StepExecutionReportDto)this.receiveNotification(executionId).blockingLast();
    }

    @Override
    public Long executeAsync(ExecutionRequestDto request) {
        StepDefinition stepDefinition = StepDefinitionMapper.toStepDefinition(request.scenario.definition, request.environment);
        return this.engine.execute(stepDefinition, ScenarioExecution.createScenarioExecution(this.tasksConfiguration));
    }

    @Override
    public Observable<StepExecutionReportDto> receiveNotification(Long executionId) {
        return this.reporter.subscribeOnExecution(executionId).map(StepExecutionReportMapper::toDto);
    }

    @Override
    public void pauseExecution(Long executionId) {
        this.executionManager.pauseExecution(executionId);
    }

    @Override
    public void resumeExecution(Long executionId) {
        this.executionManager.resumeExecution(executionId);
    }

    @Override
    public void stopExecution(Long executionId) {
        this.executionManager.stopExecution(executionId);
    }
}

