/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.report;

import com.chutneytesting.engine.domain.execution.RxBus;
import com.chutneytesting.engine.domain.execution.engine.step.Step;
import com.chutneytesting.engine.domain.execution.event.BeginStepExecutionEvent;
import com.chutneytesting.engine.domain.execution.event.EndScenarioExecutionEvent;
import com.chutneytesting.engine.domain.execution.event.EndStepExecutionEvent;
import com.chutneytesting.engine.domain.execution.event.Event;
import com.chutneytesting.engine.domain.execution.event.PauseStepExecutionEvent;
import com.chutneytesting.engine.domain.execution.event.StartScenarioExecutionEvent;
import com.chutneytesting.engine.domain.execution.report.StepExecutionReport;
import com.chutneytesting.engine.domain.execution.report.StepExecutionReportBuilder;
import com.chutneytesting.engine.domain.execution.strategies.StepStrategyDefinition;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.subjects.ReplaySubject;
import io.reactivex.subjects.Subject;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Reporter.class);
    private static final long DEFAULT_RETENTION_DELAY_SECONDS = 5L;
    private Map<Long, Subject<StepExecutionReport>> reportsPublishers = new ConcurrentHashMap<Long, Subject<StepExecutionReport>>();
    private Map<Long, Step> rootSteps = new ConcurrentHashMap<Long, Step>();
    private long retentionDelaySeconds;

    public Reporter() {
        this(5L);
    }

    public Reporter(long retentionDelaySeconds) {
        this.retentionDelaySeconds = retentionDelaySeconds;
        this.busRegistration();
    }

    public Observable<StepExecutionReport> subscribeOnExecution(Long executionId) {
        LOGGER.trace("Subscribe for execution {}", (Object)executionId);
        return Optional.ofNullable((Observable)this.reportsPublishers.get(executionId)).orElseGet(Observable::empty);
    }

    public void setRetentionDelaySeconds(long retentionDelaySeconds) {
        this.retentionDelaySeconds = retentionDelaySeconds;
    }

    public void createPublisher(Long executionId, Step rootStep) {
        LOGGER.trace("Create publisher for execution {}", (Object)executionId);
        this.reportsPublishers.put(executionId, (Subject<StepExecutionReport>)ReplaySubject.createWithSize((int)1).toSerialized());
        this.rootSteps.put(executionId, rootStep);
        LOGGER.debug("Publishers map size : {}", (Object)this.reportsPublishers.size());
    }

    private void storeRootStepAndPublishReport(StartScenarioExecutionEvent event) {
        LOGGER.trace("Store root step for execution {}", (Object)event.executionId());
        this.rootSteps.put(event.executionId(), event.step);
        this.publishReport(event);
    }

    private void publishReport(Event event) {
        LOGGER.trace("Publish report for execution {}", (Object)event.executionId());
        this.doIfPublisherExists(event.executionId(), observer -> observer.onNext((Object)this.generateReport(event.executionId())));
    }

    private void publishReportAndCompletePublisher(Event event) {
        this.doIfPublisherExists(event.executionId(), observer -> {
            this.publishReport(event);
            this.completePublisher(event.executionId(), (Observer<StepExecutionReport>)observer);
        });
    }

    private StepExecutionReport generateReport(long executionId) {
        return this.generateReport(this.rootSteps.get(executionId));
    }

    StepExecutionReport generateReport(Step step) {
        Step.StepContextImpl stepContext = step.stepContext();
        return new StepExecutionReportBuilder().setName(step.definition().name).setDuration(step.duration().toMillis()).setStartDate(step.startDate()).setStatus(step.status()).setInformation(step.informations()).setErrors(step.errors()).setSteps(step.subSteps().stream().map(this::generateReport).collect(Collectors.toList())).setEvaluatedInputs(stepContext.getEvaluatedInputs()).setStepResults(stepContext.getStepOutputs()).setScenarioContext(stepContext.getScenarioContext()).setType(step.type()).setTarget(step.target()).setStrategy(this.guardNullStrategy(step.strategy())).createStepExecutionReport();
    }

    private String guardNullStrategy(Optional<StepStrategyDefinition> strategy) {
        return strategy.map(stepStrategyDefinition -> stepStrategyDefinition.type).orElse(null);
    }

    private void completePublisher(long executionId, Observer<StepExecutionReport> observer) {
        LOGGER.trace("Complete publisher for execution {}", (Object)executionId);
        observer.onComplete();
        if (this.retentionDelaySeconds > 0L) {
            Completable.timer((long)this.retentionDelaySeconds, (TimeUnit)TimeUnit.SECONDS).subscribe(() -> {
                this.rootSteps.remove(executionId);
                this.reportsPublishers.remove(executionId);
                LOGGER.trace("Remove publisher for execution {}", (Object)executionId);
            }, throwable -> LOGGER.error("Cannot remove publisher for execution {}", (Object)executionId, throwable));
        } else {
            this.rootSteps.remove(executionId);
            this.reportsPublishers.remove(executionId);
        }
    }

    private void doIfPublisherExists(long executionId, Consumer<Observer<StepExecutionReport>> consumer) {
        Optional.ofNullable((Observer)this.reportsPublishers.get(executionId)).ifPresent(consumer);
    }

    private void busRegistration() {
        RxBus bus = RxBus.getInstance();
        bus.register(StartScenarioExecutionEvent.class, this::storeRootStepAndPublishReport);
        bus.register(BeginStepExecutionEvent.class, this::publishReport);
        bus.register(EndStepExecutionEvent.class, this::publishReport);
        bus.register(PauseStepExecutionEvent.class, this::publishReport);
        bus.register(EndScenarioExecutionEvent.class, this::publishReportAndCompletePublisher);
    }
}

