/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.report;

import com.chutneytesting.engine.domain.execution.report.Status;
import com.chutneytesting.engine.domain.execution.report.StepExecutionReport;
import com.chutneytesting.task.spi.injectable.Target;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StepExecutionReportBuilder {
    private long executionId;
    private String name;
    private long duration;
    private Instant startDate;
    private Status status;
    private List<String> information;
    private List<String> errors;
    private List<StepExecutionReport> steps;
    private String type;
    private String targetName = "";
    private String targetUrl = "";
    private String strategy = "sequential";
    private Map<String, Object> evaluatedInputs;
    private Map<String, Object> stepResults;
    private Map<String, Object> scenarioContext;

    public StepExecutionReportBuilder from(StepExecutionReport stepExecutionReport) {
        this.setExecutionId(stepExecutionReport.executionId);
        this.setName(stepExecutionReport.name);
        this.setDuration(stepExecutionReport.duration);
        this.setStartDate(stepExecutionReport.startDate);
        this.setStatus(stepExecutionReport.status);
        this.setInformation(stepExecutionReport.information);
        this.setErrors(stepExecutionReport.errors);
        this.setSteps(stepExecutionReport.steps);
        this.setType(stepExecutionReport.type);
        this.setTargetName(stepExecutionReport.targetName);
        this.setTargetUrl(stepExecutionReport.targetUrl);
        this.setStrategy(stepExecutionReport.strategy);
        this.setEvaluatedInputs(stepExecutionReport.evaluatedInputs);
        this.setStepResults(stepExecutionReport.stepResults);
        this.setScenarioContext(stepExecutionReport.scenarioContext);
        return this;
    }

    public StepExecutionReportBuilder setEvaluatedInputs(Map<String, Object> evaluatedInputs) {
        this.evaluatedInputs = evaluatedInputs;
        return this;
    }

    public StepExecutionReportBuilder setStepResults(Map<String, Object> stepResults) {
        this.stepResults = stepResults;
        return this;
    }

    public StepExecutionReportBuilder setScenarioContext(Map<String, Object> scenarioContext) {
        this.scenarioContext = scenarioContext;
        return this;
    }

    private StepExecutionReportBuilder setExecutionId(long executionId) {
        this.executionId = executionId;
        return this;
    }

    public StepExecutionReportBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public StepExecutionReportBuilder setDuration(long duration) {
        this.duration = duration;
        return this;
    }

    public StepExecutionReportBuilder setStartDate(Instant startDate) {
        this.startDate = startDate;
        return this;
    }

    public StepExecutionReportBuilder setStatus(Status status) {
        this.status = status;
        return this;
    }

    public StepExecutionReportBuilder setInformation(List<String> information) {
        this.information = information;
        return this;
    }

    public StepExecutionReportBuilder setErrors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public StepExecutionReportBuilder setSteps(List<StepExecutionReport> steps) {
        this.steps = steps;
        return this;
    }

    public StepExecutionReportBuilder setType(String type) {
        this.type = type;
        return this;
    }

    public StepExecutionReportBuilder setTarget(Target target) {
        if (target != null) {
            this.targetName = target.name();
            this.targetUrl = target.url();
        }
        return this;
    }

    public StepExecutionReportBuilder setTargetName(String name) {
        this.targetName = name;
        return this;
    }

    public StepExecutionReportBuilder setTargetUrl(String url) {
        this.targetUrl = url;
        return this;
    }

    public StepExecutionReportBuilder setStrategy(String strategy) {
        if (strategy != null) {
            this.strategy = strategy;
        }
        return this;
    }

    public StepExecutionReport createStepExecutionReport() {
        return new StepExecutionReport(this.executionId, this.name, this.duration, this.startDate, this.status, Optional.ofNullable(this.information).orElse(Collections.emptyList()), Optional.ofNullable(this.errors).orElse(Collections.emptyList()), Optional.ofNullable(this.steps).orElse(Collections.emptyList()), this.type, this.targetName, this.targetUrl, this.strategy, this.evaluatedInputs, this.stepResults, this.scenarioContext);
    }
}

