/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.engine;

import com.chutneytesting.engine.domain.execution.ScenarioExecution;
import com.chutneytesting.engine.domain.execution.StepDefinition;
import com.chutneytesting.engine.domain.execution.engine.StepExecutor;
import com.chutneytesting.engine.domain.execution.engine.parameterResolver.ContextParameterResolver;
import com.chutneytesting.engine.domain.execution.engine.parameterResolver.DelegateLogger;
import com.chutneytesting.engine.domain.execution.engine.parameterResolver.InputParameterResolver;
import com.chutneytesting.engine.domain.execution.engine.parameterResolver.TypedValueParameterResolver;
import com.chutneytesting.engine.domain.execution.engine.step.Step;
import com.chutneytesting.engine.domain.execution.engine.step.StepContext;
import com.chutneytesting.task.domain.TaskTemplate;
import com.chutneytesting.task.domain.TaskTemplateRegistry;
import com.chutneytesting.task.domain.parameter.ParameterResolver;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.task.spi.injectable.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStepExecutor
implements StepExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStepExecutor.class);
    private final TaskTemplateRegistry taskTemplateRegistry;

    public DefaultStepExecutor(TaskTemplateRegistry taskTemplateRegistry) {
        this.taskTemplateRegistry = taskTemplateRegistry;
    }

    @Override
    public void execute(ScenarioExecution scenarioExecution, StepContext stepContext, Target targetServer, Step step) {
        String type = step.type();
        Optional<TaskTemplate> matchedTask = this.taskTemplateRegistry.getByIdentifier(type);
        if (matchedTask.isPresent()) {
            List<ParameterResolver> parameterResolvers = this.gatherResolvers(scenarioExecution, stepContext, targetServer, step);
            try {
                TaskExecutionResult executionResult = matchedTask.get().create(parameterResolvers).execute();
                this.updateStepFromTaskResult(step, executionResult);
                this.updateStepContextFromTaskResult(stepContext, executionResult);
            }
            catch (Exception e) {
                LOGGER.error("Cannot execute step: ", (Throwable)e);
                step.failure("Task [" + type + "] failed: " + Optional.ofNullable(e.getMessage()).orElse(e.toString()));
            }
        } else if (type.isEmpty()) {
            step.success(new String[0]);
        } else {
            step.failure("Task [" + type + "] not found");
        }
    }

    private void updateStepContextFromTaskResult(StepContext stepContext, TaskExecutionResult executionResult) {
        if (executionResult.status == TaskExecutionResult.Status.Success) {
            stepContext.addStepOutputs(executionResult.outputs);
            stepContext.getScenarioContext().putAll(executionResult.outputs);
        }
    }

    private void updateStepFromTaskResult(Step step, TaskExecutionResult executionResult) {
        if (executionResult.status == TaskExecutionResult.Status.Success) {
            step.success(new String[0]);
        } else {
            step.failure(new String[0]);
        }
    }

    private List<ParameterResolver> gatherResolvers(ScenarioExecution scenarioExecution, StepContext stepContext, Target target, Step step) {
        ArrayList<ParameterResolver> parameterResolvers = new ArrayList<ParameterResolver>();
        parameterResolvers.add(new InputParameterResolver(stepContext.getEvaluatedInputs()));
        parameterResolvers.add(new TypedValueParameterResolver<Target>(Target.class, target));
        parameterResolvers.add(new TypedValueParameterResolver<DelegateLogger>(com.chutneytesting.task.spi.injectable.Logger.class, new DelegateLogger(xva$0 -> step.addInformation((String)xva$0), xva$0 -> step.failure((String)xva$0))));
        parameterResolvers.add(new TypedValueParameterResolver<StepDefinition>(StepDefinition.class, step.definition()));
        parameterResolvers.add(new TypedValueParameterResolver<FinallyActionRegistry>(FinallyActionRegistry.class, scenarioExecution::registerFinallyAction));
        parameterResolvers.add(new ContextParameterResolver(stepContext.getScenarioContext()));
        return parameterResolvers;
    }
}

