/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.engine;

import com.chutneytesting.engine.domain.delegation.DelegationService;
import com.chutneytesting.engine.domain.execution.ExecutionEngine;
import com.chutneytesting.engine.domain.execution.RxBus;
import com.chutneytesting.engine.domain.execution.ScenarioExecution;
import com.chutneytesting.engine.domain.execution.StepDefinition;
import com.chutneytesting.engine.domain.execution.engine.FinallyActionMapper;
import com.chutneytesting.engine.domain.execution.engine.StepExecutor;
import com.chutneytesting.engine.domain.execution.engine.evaluation.StepDataEvaluator;
import com.chutneytesting.engine.domain.execution.engine.scenario.ScenarioContextImpl;
import com.chutneytesting.engine.domain.execution.engine.step.Step;
import com.chutneytesting.engine.domain.execution.event.EndScenarioExecutionEvent;
import com.chutneytesting.engine.domain.execution.event.StartScenarioExecutionEvent;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategies;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategy;
import com.chutneytesting.engine.domain.report.Reporter;
import com.chutneytesting.task.spi.injectable.Target;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutionEngine
implements ExecutionEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutionEngine.class);
    private final ExecutorService executorService = Executors.newFixedThreadPool(10);
    private final StepDataEvaluator dataEvaluator;
    private final StepExecutionStrategies stepExecutionStrategies;
    private final DelegationService delegationService;
    private final Reporter reporter;

    public DefaultExecutionEngine(StepDataEvaluator dataEvaluator, StepExecutionStrategies stepExecutionStrategies, DelegationService delegationService, Reporter reporter) {
        this.dataEvaluator = dataEvaluator;
        this.stepExecutionStrategies = stepExecutionStrategies != null ? stepExecutionStrategies : new StepExecutionStrategies();
        this.delegationService = delegationService;
        this.reporter = reporter;
    }

    @Override
    public Long execute(StepDefinition stepDefinition, ScenarioExecution execution) {
        AtomicReference<Step> rootStep = new AtomicReference<Step>(Step.nonExecutable(stepDefinition));
        this.reporter.createPublisher(execution.executionId, rootStep.get());
        this.executorService.submit(() -> {
            ScenarioContextImpl scenarioContext = new ScenarioContextImpl();
            try {
                rootStep.set(this.buildStep(stepDefinition));
                RxBus.getInstance().post(new StartScenarioExecutionEvent(execution, (Step)rootStep.get()));
                StepExecutionStrategy strategy = this.stepExecutionStrategies.buildStrategyFrom((Step)rootStep.get());
                strategy.execute(execution, (Step)rootStep.get(), scenarioContext, this.stepExecutionStrategies);
            }
            catch (RuntimeException e) {
                ((Step)rootStep.get()).failure(e);
                LOGGER.warn("Intercepted exception!", (Throwable)e);
            }
            try {
                execution.executeFinallyActions(scenarioContext, finallyAction -> this.buildStep(new FinallyActionMapper().toStepDefinition(finallyAction)));
            }
            catch (RuntimeException e) {
                ((Step)rootStep.get()).failure(e);
                LOGGER.warn("Teardown did not finish properly !", (Throwable)e);
            }
            RxBus.getInstance().post(new EndScenarioExecutionEvent(execution, (Step)rootStep.get()));
        });
        return execution.executionId;
    }

    private Step buildStep(StepDefinition definition) {
        LOGGER.debug("Build : " + definition);
        Optional<Target> target = definition.getTarget();
        StepExecutor executor = this.delegationService.findExecutor(target);
        List<Step> steps = Collections.unmodifiableList(definition.steps.stream().map(this::buildStep).collect(Collectors.toList()));
        return new Step(this.dataEvaluator, definition, target, executor, steps);
    }
}

