/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution;

import com.chutneytesting.engine.domain.execution.RxBus;
import com.chutneytesting.engine.domain.execution.action.PauseExecutionAction;
import com.chutneytesting.engine.domain.execution.action.ResumeExecutionAction;
import com.chutneytesting.engine.domain.execution.action.StopExecutionAction;
import com.chutneytesting.engine.domain.execution.engine.scenario.ScenarioContext;
import com.chutneytesting.engine.domain.execution.engine.scenario.StepBuilder;
import com.chutneytesting.engine.domain.execution.engine.step.Step;
import com.chutneytesting.engine.domain.execution.event.EndScenarioExecutionEvent;
import com.chutneytesting.engine.domain.execution.event.Event;
import com.chutneytesting.task.spi.FinallyAction;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScenarioExecution.class);
    private final List<FinallyAction> finallyActions = new ArrayList<FinallyAction>();
    public final long executionId;
    private boolean pause = false;
    private boolean stop = false;
    private Disposable endExecutionSubscriber;

    public static ScenarioExecution createScenarioExecution() {
        long executionId = UUID.randomUUID().getMostSignificantBits();
        return new ScenarioExecution(executionId);
    }

    private ScenarioExecution(long executionId) {
        this.executionId = executionId;
        Disposable pauseSubscriber = RxBus.getInstance().registerOnExecutionId(PauseExecutionAction.class, executionId, (Consumer<? super Event>)((Consumer)e -> this.pause()));
        Disposable stopSubscriber = RxBus.getInstance().registerOnExecutionId(StopExecutionAction.class, executionId, (Consumer<? super Event>)((Consumer)e -> this.stop()));
        Disposable resumeSubscriber = RxBus.getInstance().registerOnExecutionId(ResumeExecutionAction.class, executionId, (Consumer<? super Event>)((Consumer)e -> this.resume()));
        this.endExecutionSubscriber = RxBus.getInstance().registerOnExecutionId(EndScenarioExecutionEvent.class, executionId, (Consumer<? super Event>)((Consumer)e -> {
            pauseSubscriber.dispose();
            stopSubscriber.dispose();
            resumeSubscriber.dispose();
            this.endExecutionSubscriber.dispose();
        }));
    }

    public void registerFinallyAction(FinallyAction finallyAction) {
        this.finallyActions.add(finallyAction);
    }

    public void executeFinallyActions(ScenarioContext scenarioContext, StepBuilder stepBuilder) {
        this.stop = false;
        ArrayList<FinallyAction> finallyActionsSnapshot = new ArrayList<FinallyAction>(this.finallyActions);
        Collections.reverse(finallyActionsSnapshot);
        for (FinallyAction finallyAction : Collections.unmodifiableList(finallyActionsSnapshot)) {
            try {
                Step step = stepBuilder.buildStep(finallyAction);
                step.execute(this, scenarioContext);
            }
            catch (RuntimeException e) {
                LOGGER.error("Error when executing finallyActions", (Throwable)e);
            }
        }
    }

    public void waitForRestart() {
        while (this.pause) {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean hasToPause() {
        return this.pause;
    }

    public boolean hasToStop() {
        return this.stop;
    }

    private void pause() {
        this.pause = true;
    }

    private void stop() {
        this.stop = true;
    }

    private void resume() {
        this.pause = false;
    }
}

