/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution;

import com.chutneytesting.engine.domain.execution.event.Event;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;

public class RxBus {
    private static final RxBus INSTANCE = new RxBus();
    private Subject<Object> bus = PublishSubject.create().toSerialized();

    public static RxBus getInstance() {
        return INSTANCE;
    }

    public void post(Object event) {
        this.bus.onNext(event);
    }

    public <T> Disposable register(Class<T> eventClass, Consumer<T> onNext) {
        return this.bus.filter(event -> event.getClass().equals(eventClass)).map(obj -> obj).subscribe(onNext);
    }

    public <T extends Event> Disposable registerOnExecutionId(Class<T> eventClass, long executionId, Consumer<? super Event> onNext) {
        return this.bus.filter(event -> event.getClass().equals(eventClass)).map(obj -> (Event)obj).filter(e -> e.executionId() == executionId).subscribe(onNext);
    }

    public Observable<Object> toObservable() {
        return this.bus;
    }
}

