/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.environment;

import com.chutneytesting.task.spi.injectable.SecurityInfo;
import java.util.Objects;
import java.util.Optional;

public class SecurityInfoImpl
implements SecurityInfo {
    private Credential credential;
    private String trustStore;
    private String trustStorePassword;
    private String keyStore;
    private String keyStorePassword;
    private String privateKey;

    private SecurityInfoImpl(Credential credential, String trustStore, String trustStorePassword, String keyStore, String keyStorePassword, String privateKey) {
        this.credential = credential;
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.privateKey = privateKey;
    }

    public static SecurityInfoBuilder builder() {
        return new SecurityInfoBuilder();
    }

    public Optional<SecurityInfo.Credential> credential() {
        return this.hasCredential() ? Optional.of(this.credential) : Optional.empty();
    }

    public boolean hasCredential() {
        return Optional.ofNullable(this.credential).isPresent() && !Credential.NONE.equals(this.credential);
    }

    public Optional<String> trustStore() {
        return Optional.ofNullable(this.trustStore);
    }

    public Optional<String> trustStorePassword() {
        return Optional.ofNullable(this.trustStorePassword);
    }

    public Optional<String> keyStore() {
        return Optional.ofNullable(this.keyStore);
    }

    public Optional<String> keyStorePassword() {
        return Optional.ofNullable(this.keyStorePassword);
    }

    public Optional<String> privateKey() {
        return Optional.ofNullable(this.privateKey);
    }

    public boolean hasTrustStore() {
        return Optional.ofNullable(this.trustStore).isPresent() && !"".equals(this.trustStore);
    }

    public boolean hasKeyStore() {
        return Optional.ofNullable(this.keyStore).isPresent() && !"".equals(this.keyStore);
    }

    public boolean hasPrivateKey() {
        return Optional.ofNullable(this.privateKey).isPresent() && !"".equals(this.privateKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityInfoImpl that = (SecurityInfoImpl)o;
        return Objects.equals(this.credential, that.credential) && Objects.equals(this.trustStore, that.trustStore) && Objects.equals(this.trustStorePassword, that.trustStorePassword) && Objects.equals(this.keyStore, that.keyStore) && Objects.equals(this.keyStorePassword, that.keyStorePassword) && Objects.equals(this.privateKey, that.privateKey);
    }

    public int hashCode() {
        return Objects.hash(this.credential, this.trustStore, this.trustStorePassword, this.keyStore, this.keyStorePassword, this.privateKey);
    }

    public static class Credential
    implements SecurityInfo.Credential {
        public static final Credential NONE = new NoCredential();
        public final String username;
        public final String password;

        private Credential(String username, String password) {
            this.username = Optional.ofNullable(username).orElse("");
            this.password = Optional.ofNullable(password).orElse("");
        }

        public static Credential of(String username, String password) {
            return new Credential(username, password);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Credential that = (Credential)o;
            return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
        }

        public int hashCode() {
            return Objects.hash(this.username, this.password);
        }

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }

        private static class NoCredential
        extends Credential {
            private NoCredential() {
                super("", "");
            }
        }
    }

    public static final class SecurityInfoBuilder {
        private Credential credential;
        private String trustStore;
        private String trustStorePassword;
        private String keyStore;
        private String keyStorePassword;
        private String privateKey;

        private SecurityInfoBuilder() {
        }

        public SecurityInfoImpl build() {
            return new SecurityInfoImpl(this.credential, this.trustStore, this.trustStorePassword, this.keyStore, this.keyStorePassword, this.privateKey);
        }

        public SecurityInfoBuilder credential(Credential credential) {
            this.credential = credential;
            return this;
        }

        public SecurityInfoBuilder trustStore(String trustStore) {
            this.trustStore = trustStore;
            return this;
        }

        public SecurityInfoBuilder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public SecurityInfoBuilder keyStore(String keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        public SecurityInfoBuilder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public SecurityInfoBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }
    }
}

