/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.delegation;

import java.util.Objects;
import java.util.Optional;

public class NamedHostAndPort {
    private String name;
    private String host;
    private int port;

    public NamedHostAndPort(String name, String host, int port) {
        this.name = Optional.ofNullable(name).orElseThrow(() -> new IllegalArgumentException("Name should not be null"));
        this.host = Optional.ofNullable(host).orElseThrow(() -> new IllegalArgumentException("Host should not be null"));
        this.port = Optional.ofNullable(port).orElseThrow(() -> new IllegalArgumentException("Port should not be null"));
    }

    public String name() {
        return this.name;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String toString() {
        return "name='" + this.name + "', host='" + this.host + "', port=" + this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedHostAndPort that = (NamedHostAndPort)o;
        return this.port == that.port && Objects.equals(this.name, that.name) && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.host, this.port);
    }
}

