/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.api.execution;

import com.chutneytesting.engine.api.execution.CredentialExecutionDto;
import com.chutneytesting.engine.api.execution.SecurityInfoExecutionDto;
import com.chutneytesting.engine.api.execution.StepDefinitionDto;
import com.chutneytesting.engine.api.execution.TargetExecutionDto;
import com.chutneytesting.engine.domain.environment.SecurityInfoImpl;
import com.chutneytesting.engine.domain.environment.TargetImpl;
import com.chutneytesting.engine.domain.execution.StepDefinition;
import com.chutneytesting.engine.domain.execution.strategies.StepStrategyDefinition;
import com.chutneytesting.engine.domain.execution.strategies.StrategyProperties;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class StepDefinitionMapper {
    private StepDefinitionMapper() {
    }

    static StepDefinition toStepDefinition(StepDefinitionDto dto) {
        StepStrategyDefinition strategy = null;
        if (dto.strategy != null) {
            StrategyProperties strategyProperties = new StrategyProperties(dto.strategy.strategyProperties);
            strategy = new StepStrategyDefinition(dto.strategy.type, strategyProperties);
        }
        List<StepDefinition> steps = dto.steps.stream().map(StepDefinitionMapper::toStepDefinition).collect(Collectors.toList());
        return new StepDefinition(dto.name != null ? dto.name : "", dto.getTarget().isPresent() ? StepDefinitionMapper.fromDto(dto.getTarget().get()) : null, dto.type != null ? dto.type : "", strategy, dto.inputs, steps, dto.outputs, dto.environment);
    }

    private static TargetImpl fromDto(TargetExecutionDto targetDto) {
        return TargetImpl.builder().withName(targetDto.id).withUrl(targetDto.url).withAgents(targetDto.agents).withProperties(targetDto.properties).withSecurity(StepDefinitionMapper.fromDto(targetDto.security)).build();
    }

    private static SecurityInfoImpl fromDto(SecurityInfoExecutionDto dto) {
        return SecurityInfoImpl.builder().credential(StepDefinitionMapper.fromDto(dto.credential)).keyStore(dto.keyStore).keyStorePassword(dto.keyStorePassword).trustStore(dto.trustStore).trustStorePassword(dto.trustStorePassword).privateKey(dto.privateKey).build();
    }

    private static SecurityInfoImpl.Credential fromDto(CredentialExecutionDto credential) {
        return Optional.ofNullable(credential).map(c -> SecurityInfoImpl.Credential.of(c.username, c.password)).orElse(SecurityInfoImpl.Credential.NONE);
    }
}

