/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.infra.wrapper;

import com.chutneytesting.component.scenario.domain.ComposableStep;
import com.chutneytesting.component.scenario.infra.orient.OrientUtils;
import com.chutneytesting.component.scenario.infra.wrapper.StepVertex;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.server.core.domain.security.User;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TestCaseVertex {
    private final OVertex testCaseVertex;
    private final StepVertex scenario;

    private TestCaseVertex(OVertex testCaseVertex, List<ComposableStep> subSteps) {
        this.testCaseVertex = testCaseVertex;
        this.scenario = StepVertex.builder().from(testCaseVertex).withSteps(subSteps).build();
    }

    public OVertex save(ODatabaseSession dbSession) {
        this.scenario.save(dbSession);
        return (OVertex)this.testCaseVertex.save();
    }

    public String id() {
        return this.testCaseVertex.getIdentity().toString();
    }

    public String title() {
        return (String)this.testCaseVertex.getProperty("title");
    }

    public String description() {
        return (String)this.testCaseVertex.getProperty("description");
    }

    public Instant creationDate() {
        return ((Date)this.testCaseVertex.getProperty("created")).toInstant();
    }

    public List<String> tags() {
        return (List)this.testCaseVertex.getProperty("tags");
    }

    public String datasetId() {
        return (String)this.testCaseVertex.getProperty("datasetId");
    }

    public Instant updateDate() {
        return ((Date)this.testCaseVertex.getProperty("updated")).toInstant();
    }

    public String author() {
        return (String)this.testCaseVertex.getProperty("author");
    }

    public Integer version() {
        return this.testCaseVertex.getVersion();
    }

    public List<StepVertex> scenario() {
        return this.scenario.listChildrenSteps();
    }

    public Map<String, String> parameters() {
        return (Map)this.testCaseVertex.getProperty("parameters");
    }

    public static TestCaseVertexBuilder builder() {
        return new TestCaseVertexBuilder();
    }

    public static class TestCaseVertexBuilder {
        String id;
        OVertex vertex;
        private String title;
        private String description;
        private Date creationDate;
        private List<String> tags;
        private Map<String, String> parameters;
        private String datasetId;
        private Date updateDate;
        private String author;
        private List<ComposableStep> steps;

        private TestCaseVertexBuilder() {
        }

        public TestCaseVertex build() {
            if (this.vertex == null) {
                throw new ScenarioNotFoundException(this.id);
            }
            Optional.ofNullable(this.title).ifPresent(t -> this.vertex.setProperty("title", t, new OType[]{OType.STRING}));
            Optional.ofNullable(this.description).ifPresent(d -> OrientUtils.setOrRemoveProperty((OElement)this.vertex, "description", d, OType.STRING));
            Optional.ofNullable(this.creationDate).ifPresent(cd -> OrientUtils.setOnlyOnceProperty((OElement)this.vertex, "created", cd, OType.DATETIME));
            Optional.ofNullable(this.tags).ifPresent(t -> this.vertex.setProperty("tags", t, new OType[]{OType.EMBEDDEDLIST}));
            Optional.ofNullable(this.parameters).ifPresent(p -> OrientUtils.setOrRemoveProperty((OElement)this.vertex, "parameters", p, OType.EMBEDDEDMAP));
            Optional.ofNullable(this.datasetId).ifPresent(d -> OrientUtils.setOrRemoveProperty((OElement)this.vertex, "datasetId", d, OType.STRING));
            Optional.ofNullable(this.updateDate).ifPresent(ud -> this.vertex.setProperty("updated", ud, new OType[]{OType.DATETIME}));
            Optional.ofNullable(this.author).ifPresent(author -> OrientUtils.setOrRemoveProperty((OElement)this.vertex, "author", author, a -> !User.isAnonymous((String)a), OType.STRING));
            return new TestCaseVertex(this.vertex, this.steps);
        }

        public TestCaseVertexBuilder from(OVertex vertex) {
            this.vertex = vertex;
            return this;
        }

        public TestCaseVertexBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public TestCaseVertexBuilder withTitle(String title) {
            this.title = title;
            return this;
        }

        public TestCaseVertexBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public TestCaseVertexBuilder withCreationDate(Date creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public TestCaseVertexBuilder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public TestCaseVertexBuilder withParameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public TestCaseVertexBuilder withDatasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public TestCaseVertexBuilder withUpdateDate(Date updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public TestCaseVertexBuilder withAuthor(String author) {
            this.author = author;
            return this;
        }

        public TestCaseVertexBuilder withSteps(List<ComposableStep> composableSteps) {
            this.steps = composableSteps;
            return this;
        }
    }
}

