/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.domain;

import com.chutneytesting.component.scenario.domain.ComposableScenario;
import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadataImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ComposableTestCase
implements TestCase {
    public final String id;
    public final TestCaseMetadata metadata;
    public final ComposableScenario composableScenario;
    public final Map<String, String> executionParameters;

    public ComposableTestCase(String id, TestCaseMetadata metadata, ComposableScenario composableScenario) {
        this.id = id;
        this.metadata = metadata;
        this.composableScenario = composableScenario;
        this.executionParameters = this.getExecutionParameters();
    }

    private ComposableTestCase(String id, TestCaseMetadata metadata, ComposableScenario composableScenario, Map<String, String> executionParameters) {
        this.id = id;
        this.metadata = metadata;
        this.composableScenario = composableScenario;
        this.executionParameters = executionParameters;
    }

    public TestCaseMetadata metadata() {
        return this.metadata;
    }

    public String id() {
        return this.id;
    }

    public Map<String, String> executionParameters() {
        return this.executionParameters;
    }

    public TestCase usingExecutionParameters(Map<String, String> parameters) {
        return new ComposableTestCase(this.id, this.metadata, this.composableScenario, parameters);
    }

    public TestCase withDataSetId(String dataSetId) {
        return new ComposableTestCase(this.id, (TestCaseMetadata)TestCaseMetadataImpl.TestCaseMetadataBuilder.from((TestCaseMetadata)this.metadata).withDefaultDataset(dataSetId).build(), this.composableScenario, this.executionParameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComposableTestCase that = (ComposableTestCase)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.composableScenario, that.composableScenario) && Objects.equals(this.executionParameters, that.executionParameters);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.metadata, this.composableScenario, this.executionParameters);
    }

    private Map<String, String> getExecutionParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.composableScenario.composableSteps.forEach(composableStep -> parameters.putAll(composableStep.getEmptyExecutionParameters()));
        Optional.ofNullable(this.composableScenario.parameters).ifPresent(parameters::putAll);
        return parameters;
    }

    public String toString() {
        return "ComposableTestCase{id='" + this.id + "', metadata=" + this.metadata + ", composableScenario=" + this.composableScenario + ", parameters=" + this.executionParameters + "}";
    }
}

