/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.execution.domain;

import com.chutneytesting.component.dataset.infra.OrientDataSetRepository;
import com.chutneytesting.component.execution.domain.ComposedTestCaseDatatableIterationsPreProcessor;
import com.chutneytesting.component.execution.domain.ComposedTestCaseParametersResolutionPreProcessor;
import com.chutneytesting.component.execution.domain.ExecutableComposedTestCase;
import com.chutneytesting.server.core.domain.execution.ExecutionRequest;
import com.chutneytesting.server.core.domain.execution.processor.TestCasePreProcessor;
import com.chutneytesting.server.core.domain.globalvar.GlobalvarRepository;
import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ComposedTestCasePreProcessor
implements TestCasePreProcessor<ExecutableComposedTestCase> {
    private final ComposedTestCaseParametersResolutionPreProcessor parametersResolutionPreProcessor;
    private final ComposedTestCaseDatatableIterationsPreProcessor dataSetPreProcessor;

    public ComposedTestCasePreProcessor(ObjectMapper objectMapper, GlobalvarRepository globalvarRepository, OrientDataSetRepository dataSetRepository) {
        this.parametersResolutionPreProcessor = new ComposedTestCaseParametersResolutionPreProcessor(globalvarRepository, objectMapper);
        this.dataSetPreProcessor = new ComposedTestCaseDatatableIterationsPreProcessor(dataSetRepository);
    }

    public ExecutableComposedTestCase apply(ExecutionRequest executionRequest) {
        String environment = executionRequest.environment;
        String userId = executionRequest.userId;
        ExecutableComposedTestCase testCase = (ExecutableComposedTestCase)executionRequest.testCase;
        if (Optional.ofNullable(testCase.metadata.defaultDataset()).isPresent()) {
            testCase = this.dataSetPreProcessor.apply(new ExecutionRequest((TestCase)testCase, environment, userId));
        }
        return this.parametersResolutionPreProcessor.apply(new ExecutionRequest((TestCase)testCase, environment, userId));
    }
}

