/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.dataset.api;

import com.chutneytesting.component.dataset.api.DataSetDto;
import com.chutneytesting.server.core.domain.tools.ui.KeyValue;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DataSetDto", generator="Immutables")
@Immutable
public final class ImmutableDataSetDto
implements DataSetDto {
    @Nullable
    private final String id;
    private final String name;
    private final Integer version;
    private final String description;
    private final Instant lastUpdated;
    private final List<String> tags;
    private final List<KeyValue> constants;
    private final List<List<KeyValue>> datatable;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDataSetDto(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        if (builder.version != null) {
            this.initShim.version(builder.version);
        }
        if (builder.description != null) {
            this.initShim.description(builder.description);
        }
        if (builder.lastUpdated != null) {
            this.initShim.lastUpdated(builder.lastUpdated);
        }
        if (builder.tagsIsSet()) {
            this.initShim.tags(ImmutableDataSetDto.createUnmodifiableList(true, builder.tags));
        }
        if (builder.constantsIsSet()) {
            this.initShim.constants(ImmutableDataSetDto.createUnmodifiableList(true, builder.constants));
        }
        if (builder.datatableIsSet()) {
            this.initShim.datatable(ImmutableDataSetDto.createUnmodifiableList(true, builder.datatable));
        }
        this.version = this.initShim.version();
        this.description = this.initShim.description();
        this.lastUpdated = this.initShim.lastUpdated();
        this.tags = this.initShim.tags();
        this.constants = this.initShim.constants();
        this.datatable = this.initShim.datatable();
        this.initShim = null;
    }

    private ImmutableDataSetDto(@Nullable String id, String name, Integer version, String description, Instant lastUpdated, List<String> tags, List<KeyValue> constants, List<List<KeyValue>> datatable) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.description = description;
        this.lastUpdated = lastUpdated;
        this.tags = tags;
        this.constants = constants;
        this.datatable = datatable;
        this.initShim = null;
    }

    private Integer versionInitialize() {
        return DataSetDto.super.version();
    }

    private String descriptionInitialize() {
        return DataSetDto.super.description();
    }

    private Instant lastUpdatedInitialize() {
        return DataSetDto.super.lastUpdated();
    }

    private List<String> tagsInitialize() {
        return DataSetDto.super.tags();
    }

    private List<KeyValue> constantsInitialize() {
        return DataSetDto.super.constants();
    }

    private List<List<KeyValue>> datatableInitialize() {
        return DataSetDto.super.datatable();
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="version")
    public Integer version() {
        InitShim shim = this.initShim;
        return shim != null ? shim.version() : this.version;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        InitShim shim = this.initShim;
        return shim != null ? shim.description() : this.description;
    }

    @Override
    @JsonProperty(value="lastUpdated")
    public Instant lastUpdated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.lastUpdated() : this.lastUpdated;
    }

    @Override
    @JsonProperty(value="tags")
    public List<String> tags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tags() : this.tags;
    }

    @Override
    @JsonProperty(value="uniqueValues")
    public List<KeyValue> constants() {
        InitShim shim = this.initShim;
        return shim != null ? shim.constants() : this.constants;
    }

    @Override
    @JsonProperty(value="multipleValues")
    public List<List<KeyValue>> datatable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.datatable() : this.datatable;
    }

    public final ImmutableDataSetDto withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableDataSetDto(newValue, this.name, this.version, this.description, this.lastUpdated, this.tags, this.constants, this.datatable);
    }

    public final ImmutableDataSetDto withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableDataSetDto(value, this.name, this.version, this.description, this.lastUpdated, this.tags, this.constants, this.datatable);
    }

    public final ImmutableDataSetDto withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableDataSetDto(this.id, newValue, this.version, this.description, this.lastUpdated, this.tags, this.constants, this.datatable);
    }

    public final ImmutableDataSetDto withVersion(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableDataSetDto(this.id, this.name, newValue, this.description, this.lastUpdated, this.tags, this.constants, this.datatable);
    }

    public final ImmutableDataSetDto withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableDataSetDto(this.id, this.name, this.version, newValue, this.lastUpdated, this.tags, this.constants, this.datatable);
    }

    public final ImmutableDataSetDto withLastUpdated(Instant value) {
        if (this.lastUpdated == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "lastUpdated");
        return new ImmutableDataSetDto(this.id, this.name, this.version, this.description, newValue, this.tags, this.constants, this.datatable);
    }

    public final ImmutableDataSetDto withTags(String ... elements) {
        List<String> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.version, this.description, this.lastUpdated, newValue, this.constants, this.datatable);
    }

    public final ImmutableDataSetDto withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        List<String> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(elements, true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.version, this.description, this.lastUpdated, newValue, this.constants, this.datatable);
    }

    public final ImmutableDataSetDto withConstants(KeyValue ... elements) {
        List<KeyValue> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.version, this.description, this.lastUpdated, this.tags, newValue, this.datatable);
    }

    public final ImmutableDataSetDto withConstants(Iterable<? extends KeyValue> elements) {
        if (this.constants == elements) {
            return this;
        }
        List<KeyValue> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(elements, true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.version, this.description, this.lastUpdated, this.tags, newValue, this.datatable);
    }

    @SafeVarargs
    public final ImmutableDataSetDto withDatatable(List<KeyValue> ... elements) {
        List<List<KeyValue>> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.version, this.description, this.lastUpdated, this.tags, this.constants, newValue);
    }

    public final ImmutableDataSetDto withDatatable(Iterable<? extends List<KeyValue>> elements) {
        if (this.datatable == elements) {
            return this;
        }
        List<List<KeyValue>> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(elements, true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.version, this.description, this.lastUpdated, this.tags, this.constants, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDataSetDto && this.equalTo(0, (ImmutableDataSetDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableDataSetDto another) {
        return Objects.equals(this.id, another.id) && this.name.equals(another.name) && this.version.equals(another.version) && this.description.equals(another.description) && this.lastUpdated.equals(another.lastUpdated) && this.tags.equals(another.tags) && this.constants.equals(another.constants) && this.datatable.equals(another.datatable);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.lastUpdated.hashCode();
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.constants.hashCode();
        h += (h << 5) + this.datatable.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DataSetDto{");
        if (this.id != null) {
            builder.append("id=").append(this.id);
        }
        if (builder.length() > 11) {
            builder.append(", ");
        }
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("version=").append(this.version);
        builder.append(", ");
        builder.append("description=").append(this.description);
        builder.append(", ");
        builder.append("lastUpdated=").append(this.lastUpdated);
        builder.append(", ");
        builder.append("tags=").append(this.tags);
        builder.append(", ");
        builder.append("constants=").append(this.constants);
        builder.append(", ");
        builder.append("datatable=").append(this.datatable);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDataSetDto fromJson(Json json) {
        Builder builder = ImmutableDataSetDto.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.lastUpdated != null) {
            builder.lastUpdated(json.lastUpdated);
        }
        if (json.tagsIsSet) {
            builder.addAllTags(json.tags);
        }
        if (json.constantsIsSet) {
            builder.addAllConstants(json.constants);
        }
        if (json.datatableIsSet) {
            builder.addAllDatatable(json.datatable);
        }
        return builder.build();
    }

    public static ImmutableDataSetDto copyOf(DataSetDto instance) {
        if (instance instanceof ImmutableDataSetDto) {
            return (ImmutableDataSetDto)instance;
        }
        return ImmutableDataSetDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="DataSetDto", generator="Immutables")
    private final class InitShim {
        private byte versionBuildStage = 0;
        private Integer version;
        private byte descriptionBuildStage = 0;
        private String description;
        private byte lastUpdatedBuildStage = 0;
        private Instant lastUpdated;
        private byte tagsBuildStage = 0;
        private List<String> tags;
        private byte constantsBuildStage = 0;
        private List<KeyValue> constants;
        private byte datatableBuildStage = 0;
        private List<List<KeyValue>> datatable;

        private InitShim() {
        }

        Integer version() {
            if (this.versionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionBuildStage == 0) {
                this.versionBuildStage = (byte)-1;
                this.version = Objects.requireNonNull(ImmutableDataSetDto.this.versionInitialize(), "version");
                this.versionBuildStage = 1;
            }
            return this.version;
        }

        void version(Integer version) {
            this.version = version;
            this.versionBuildStage = 1;
        }

        String description() {
            if (this.descriptionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.descriptionBuildStage == 0) {
                this.descriptionBuildStage = (byte)-1;
                this.description = Objects.requireNonNull(ImmutableDataSetDto.this.descriptionInitialize(), "description");
                this.descriptionBuildStage = 1;
            }
            return this.description;
        }

        void description(String description) {
            this.description = description;
            this.descriptionBuildStage = 1;
        }

        Instant lastUpdated() {
            if (this.lastUpdatedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lastUpdatedBuildStage == 0) {
                this.lastUpdatedBuildStage = (byte)-1;
                this.lastUpdated = Objects.requireNonNull(ImmutableDataSetDto.this.lastUpdatedInitialize(), "lastUpdated");
                this.lastUpdatedBuildStage = 1;
            }
            return this.lastUpdated;
        }

        void lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            this.lastUpdatedBuildStage = 1;
        }

        List<String> tags() {
            if (this.tagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tagsBuildStage == 0) {
                this.tagsBuildStage = (byte)-1;
                this.tags = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(ImmutableDataSetDto.this.tagsInitialize(), true, false));
                this.tagsBuildStage = 1;
            }
            return this.tags;
        }

        void tags(List<String> tags) {
            this.tags = tags;
            this.tagsBuildStage = 1;
        }

        List<KeyValue> constants() {
            if (this.constantsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.constantsBuildStage == 0) {
                this.constantsBuildStage = (byte)-1;
                this.constants = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(ImmutableDataSetDto.this.constantsInitialize(), true, false));
                this.constantsBuildStage = 1;
            }
            return this.constants;
        }

        void constants(List<KeyValue> constants) {
            this.constants = constants;
            this.constantsBuildStage = 1;
        }

        List<List<KeyValue>> datatable() {
            if (this.datatableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.datatableBuildStage == 0) {
                this.datatableBuildStage = (byte)-1;
                this.datatable = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(ImmutableDataSetDto.this.datatableInitialize(), true, false));
                this.datatableBuildStage = 1;
            }
            return this.datatable;
        }

        void datatable(List<List<KeyValue>> datatable) {
            this.datatable = datatable;
            this.datatableBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.versionBuildStage == -1) {
                attributes.add("version");
            }
            if (this.descriptionBuildStage == -1) {
                attributes.add("description");
            }
            if (this.lastUpdatedBuildStage == -1) {
                attributes.add("lastUpdated");
            }
            if (this.tagsBuildStage == -1) {
                attributes.add("tags");
            }
            if (this.constantsBuildStage == -1) {
                attributes.add("constants");
            }
            if (this.datatableBuildStage == -1) {
                attributes.add("datatable");
            }
            return "Cannot build DataSetDto, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="DataSetDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long OPT_BIT_TAGS = 1L;
        private static final long OPT_BIT_CONSTANTS = 2L;
        private static final long OPT_BIT_DATATABLE = 4L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private Integer version;
        @Nullable
        private String description;
        @Nullable
        private Instant lastUpdated;
        private List<String> tags = new ArrayList<String>();
        private List<KeyValue> constants = new ArrayList<KeyValue>();
        private List<List<KeyValue>> datatable = new ArrayList<List<KeyValue>>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DataSetDto instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            this.name(instance.name());
            this.version(instance.version());
            this.description(instance.description());
            this.lastUpdated(instance.lastUpdated());
            this.addAllTags(instance.tags());
            this.addAllConstants(instance.constants());
            this.addAllDatatable(instance.datatable());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(Integer version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="lastUpdated")
        @CanIgnoreReturnValue
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = Objects.requireNonNull(lastUpdated, "lastUpdated");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String element) {
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String ... elements) {
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="tags")
        @CanIgnoreReturnValue
        public final Builder tags(Iterable<String> elements) {
            this.tags.clear();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<String> elements) {
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addConstants(KeyValue element) {
            this.constants.add(Objects.requireNonNull(element, "constants element"));
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addConstants(KeyValue ... elements) {
            for (KeyValue element : elements) {
                this.constants.add(Objects.requireNonNull(element, "constants element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="uniqueValues")
        @CanIgnoreReturnValue
        public final Builder constants(Iterable<? extends KeyValue> elements) {
            this.constants.clear();
            return this.addAllConstants(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllConstants(Iterable<? extends KeyValue> elements) {
            for (KeyValue keyValue : elements) {
                this.constants.add(Objects.requireNonNull(keyValue, "constants element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDatatable(List<KeyValue> element) {
            this.datatable.add(Objects.requireNonNull(element, "datatable element"));
            this.optBits |= 4L;
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addDatatable(List<KeyValue> ... elements) {
            for (List<KeyValue> element : elements) {
                this.datatable.add(Objects.requireNonNull(element, "datatable element"));
            }
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="multipleValues")
        @CanIgnoreReturnValue
        public final Builder datatable(Iterable<? extends List<KeyValue>> elements) {
            this.datatable.clear();
            return this.addAllDatatable(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDatatable(Iterable<? extends List<KeyValue>> elements) {
            for (List<KeyValue> list : elements) {
                this.datatable.add(Objects.requireNonNull(list, "datatable element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public ImmutableDataSetDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDataSetDto(this);
        }

        private boolean tagsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean constantsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean datatableIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build DataSetDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DataSetDto", generator="Immutables")
    static final class Json
    implements DataSetDto {
        @Nullable
        Optional<String> id = Optional.empty();
        @Nullable
        String name;
        @Nullable
        Integer version;
        @Nullable
        String description;
        @Nullable
        Instant lastUpdated;
        @Nullable
        List<String> tags = Collections.emptyList();
        boolean tagsIsSet;
        @Nullable
        List<KeyValue> constants = Collections.emptyList();
        boolean constantsIsSet;
        @Nullable
        List<List<KeyValue>> datatable = Collections.emptyList();
        boolean datatableIsSet;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="version")
        public void setVersion(Integer version) {
            this.version = version;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="lastUpdated")
        public void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
            this.tagsIsSet = true;
        }

        @JsonProperty(value="uniqueValues")
        public void setConstants(List<KeyValue> constants) {
            this.constants = constants;
            this.constantsIsSet = true;
        }

        @JsonProperty(value="multipleValues")
        public void setDatatable(List<List<KeyValue>> datatable) {
            this.datatable = datatable;
            this.datatableIsSet = true;
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer version() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant lastUpdated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> tags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<KeyValue> constants() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<List<KeyValue>> datatable() {
            throw new UnsupportedOperationException();
        }
    }
}

