/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.domain;

import com.chutneytesting.component.scenario.domain.ComposableStepCyclicDependencyException;
import com.chutneytesting.scenario.domain.gwt.Strategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ComposableStep {
    public final String id;
    public final String name;
    public final List<ComposableStep> steps;
    public final Map<String, String> defaultParameters;
    public final Optional<String> implementation;
    public final Strategy strategy;
    public final Map<String, String> executionParameters;
    public final List<String> tags;

    private ComposableStep(String id, String name, List<ComposableStep> steps, Map<String, String> defaultParameters, Optional<String> implementation, Strategy strategy, Map<String, String> executionParameters, List<String> tags) {
        this.id = id;
        this.name = name;
        this.steps = steps;
        this.defaultParameters = defaultParameters;
        this.implementation = implementation;
        this.strategy = strategy;
        this.executionParameters = executionParameters;
        this.tags = tags;
    }

    public boolean hasCyclicDependencies() {
        return this.checkCyclicDependency(this, new ArrayList<String>());
    }

    private boolean checkCyclicDependency(ComposableStep composableStep, List<String> parentsAcc) {
        if (composableStep.steps.isEmpty()) {
            return false;
        }
        parentsAcc.add(composableStep.id);
        List<String> childrenIds = composableStep.steps.stream().map(cs -> cs.id).toList();
        if (!Collections.disjoint(childrenIds, parentsAcc)) {
            return true;
        }
        return composableStep.steps.stream().anyMatch(cs -> this.checkCyclicDependency((ComposableStep)cs, (List<String>)new ArrayList<String>(parentsAcc)));
    }

    public Map<String, String> getEmptyExecutionParameters() {
        return this.executionParameters.entrySet().stream().filter(e -> StringUtils.isBlank((CharSequence)((CharSequence)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> "", LinkedHashMap::new));
    }

    public Map<String, String> getChildrenEmptyParam() {
        return this.steps.stream().flatMap(s -> s.getEmptyExecutionParameters().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> ""));
    }

    public ComposableStep usingExecutionParameters(Map<String, String> executionParameters) {
        return ComposableStep.builder().from(this).withExecutionParameters(executionParameters).build();
    }

    public String toString() {
        return "ComposableStep{id='" + this.id + "', name='" + this.name + "', steps=" + this.steps + ", defaultParameters=" + this.defaultParameters + ", implementation=" + this.implementation + ", strategy=" + this.strategy.toString() + ", executionParameters=" + this.executionParameters + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComposableStep that = (ComposableStep)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.steps, that.steps) && Objects.equals(this.defaultParameters, that.defaultParameters) && Objects.equals(this.implementation, that.implementation) && Objects.equals(this.strategy, that.strategy) && Objects.equals(this.executionParameters, that.executionParameters);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.steps, this.defaultParameters, this.implementation, this.strategy, this.executionParameters);
    }

    public static ComposableStepBuilder builder() {
        return new ComposableStepBuilder();
    }

    public static class ComposableStepBuilder {
        private String id;
        private String name;
        private List<ComposableStep> steps;
        private Map<String, String> defaultParameters;
        private Optional<String> implementation = Optional.empty();
        private Strategy strategy;
        private List<String> tags = new ArrayList<String>();
        private Map<String, String> overrideExecutionParameters;

        private ComposableStepBuilder() {
        }

        public ComposableStep build() {
            this.defaultParameters = Collections.unmodifiableMap(Optional.ofNullable(this.defaultParameters).orElse(Collections.emptyMap()));
            this.steps = Collections.unmodifiableList(Optional.ofNullable(this.steps).orElse(Collections.emptyList()));
            ComposableStep composableStep = new ComposableStep(Optional.ofNullable(this.id).orElse(""), Optional.ofNullable(this.name).orElse(""), this.steps, this.defaultParameters, this.implementation, Optional.ofNullable(this.strategy).orElse(Strategy.DEFAULT), this.resolveExecutionParameters(), Collections.unmodifiableList(Optional.ofNullable(this.tags).orElse(Collections.emptyList())));
            if (composableStep.hasCyclicDependencies()) {
                throw new ComposableStepCyclicDependencyException(composableStep.id, composableStep.name);
            }
            return composableStep;
        }

        private Map<String, String> resolveExecutionParameters() {
            Map emptyChildrenParameters = this.steps.stream().flatMap(s -> s.getEmptyExecutionParameters().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> "", LinkedHashMap::new));
            LinkedHashMap<String, String> executionParameters = new LinkedHashMap<String, String>();
            executionParameters.putAll(emptyChildrenParameters);
            executionParameters.putAll(this.defaultParameters);
            executionParameters.putAll(Optional.ofNullable(this.overrideExecutionParameters).orElse(Collections.emptyMap()));
            return executionParameters;
        }

        public ComposableStepBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public ComposableStepBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public ComposableStepBuilder withSteps(List<ComposableStep> steps) {
            this.steps = steps;
            return this;
        }

        public ComposableStepBuilder withDefaultParameters(Map<String, String> defaultParameters) {
            this.defaultParameters = defaultParameters;
            return this;
        }

        public ComposableStepBuilder withExecutionParameters(Map<String, String> executionParameters) {
            this.overrideExecutionParameters = executionParameters;
            return this;
        }

        public ComposableStepBuilder withImplementation(String implementation) {
            this.implementation = Optional.ofNullable(implementation);
            return this;
        }

        public ComposableStepBuilder withStrategy(Strategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public ComposableStepBuilder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public final ComposableStepBuilder from(ComposableStep instance) {
            this.id = instance.id;
            this.name = instance.name;
            this.steps = instance.steps;
            this.defaultParameters = instance.defaultParameters;
            this.implementation = instance.implementation;
            this.strategy = instance.strategy;
            return this;
        }
    }
}

