/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.dataset.infra;

import com.chutneytesting.component.dataset.infra.DataSetPatchUtils;
import com.chutneytesting.server.core.domain.dataset.DataSet;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DataSetPatch {
    public final String id;
    public final String refId;
    public final String name;
    public final String description;
    public final Instant creationDate;
    public final List<String> tags;
    public final String unifiedDiffValues;
    public final Integer version;

    private DataSetPatch(String id, String refId, String name, String description, Instant creationDate, List<String> tags, String unifiedDiffValues, Integer version) {
        this.id = id;
        this.refId = refId;
        this.name = name;
        this.description = description;
        this.creationDate = creationDate;
        this.tags = tags;
        this.unifiedDiffValues = unifiedDiffValues;
        this.version = version;
    }

    public boolean hasPatchedValues() {
        return this.name != null || this.description != null || this.tags != null || this.unifiedDiffValues != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSetPatch that = (DataSetPatch)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.refId, that.refId) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.tags, that.tags) && Objects.equals(this.unifiedDiffValues, that.unifiedDiffValues) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.refId, this.name, this.description, this.creationDate, this.tags, this.unifiedDiffValues, this.version);
    }

    public static DataSetPatchBuilder builder() {
        return new DataSetPatchBuilder();
    }

    public static class DataSetPatchBuilder {
        private String id;
        private String refId;
        private String name;
        private String description;
        private Instant creationDate;
        private List<String> tags;
        private String unifiedDiffValues;
        private Integer version;

        private DataSetPatchBuilder() {
        }

        public DataSetPatch build() {
            return new DataSetPatch(this.id, this.refId, this.name, this.description, this.creationDate, this.tags, this.unifiedDiffValues, this.version);
        }

        public DataSetPatchBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public DataSetPatchBuilder withRefId(String refId) {
            this.refId = refId;
            return this;
        }

        public DataSetPatchBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public DataSetPatchBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public DataSetPatchBuilder withCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public DataSetPatchBuilder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public DataSetPatchBuilder withUnifiedDiffValues(String unifiedDiffValues) {
            this.unifiedDiffValues = unifiedDiffValues;
            return this;
        }

        public DataSetPatchBuilder withVersion(Integer version) {
            this.version = version;
            return this;
        }

        public DataSetPatchBuilder fromDataSets(DataSet newDataSet, DataSet previousDataSet) {
            if (Optional.ofNullable(previousDataSet).isEmpty()) {
                return this.fromDataSets(newDataSet);
            }
            if (!newDataSet.name.equals(previousDataSet.name)) {
                this.name = newDataSet.name;
            }
            if (!newDataSet.description.equals(previousDataSet.description)) {
                this.description = newDataSet.description;
            }
            this.creationDate = newDataSet.creationDate;
            if (!newDataSet.tags.equals(previousDataSet.tags)) {
                this.tags = newDataSet.tags;
            }
            if (!newDataSet.constants.equals(previousDataSet.constants) || !newDataSet.datatable.equals(previousDataSet.datatable)) {
                this.unifiedDiffValues = DataSetPatchUtils.unifiedDiff(DataSetPatchUtils.dataSetValues(newDataSet, false), DataSetPatchUtils.dataSetValues(previousDataSet, false));
            }
            return this;
        }

        private DataSetPatchBuilder fromDataSets(DataSet newDataSet) {
            this.name = newDataSet.name;
            this.description = newDataSet.description;
            this.creationDate = newDataSet.creationDate;
            this.tags = newDataSet.tags;
            this.unifiedDiffValues = DataSetPatchUtils.unifiedDiff(DataSetPatchUtils.dataSetValues(newDataSet, false), "");
            return this;
        }
    }
}

