package com.chutneytesting.component.scenario.api.dto;

import com.chutneytesting.server.core.domain.tools.ui.KeyValue;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ComposableTestCaseDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableComposableTestCaseDto.builder()}.
 */
@Generated(from = "ComposableTestCaseDto", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableComposableTestCaseDto
    implements ComposableTestCaseDto {
  private final @Nullable String id;
  private final String title;
  private final @Nullable String description;
  private final Instant creationDate;
  private final List<String> tags;
  private final ComposableTestCaseDto.ComposableScenarioDto scenario;
  private final @Nullable String datasetId;
  private final String author;
  private final Instant updateDate;
  private final Integer version;
  private final List<KeyValue> executionParameters;

  private ImmutableComposableTestCaseDto(ImmutableComposableTestCaseDto.Builder builder) {
    this.id = builder.id;
    this.title = builder.title;
    this.description = builder.description;
    this.tags = createUnmodifiableList(true, builder.tags);
    this.scenario = builder.scenario;
    this.datasetId = builder.datasetId;
    if (builder.creationDate != null) {
      initShim.creationDate(builder.creationDate);
    }
    if (builder.author != null) {
      initShim.author(builder.author);
    }
    if (builder.updateDate != null) {
      initShim.updateDate(builder.updateDate);
    }
    if (builder.version != null) {
      initShim.version(builder.version);
    }
    if (builder.executionParametersIsSet()) {
      initShim.executionParameters(createUnmodifiableList(true, builder.executionParameters));
    }
    this.creationDate = initShim.creationDate();
    this.author = initShim.author();
    this.updateDate = initShim.updateDate();
    this.version = initShim.version();
    this.executionParameters = initShim.executionParameters();
    this.initShim = null;
  }

  private ImmutableComposableTestCaseDto(
      @Nullable String id,
      String title,
      @Nullable String description,
      Instant creationDate,
      List<String> tags,
      ComposableTestCaseDto.ComposableScenarioDto scenario,
      @Nullable String datasetId,
      String author,
      Instant updateDate,
      Integer version,
      List<KeyValue> executionParameters) {
    this.id = id;
    this.title = title;
    this.description = description;
    this.creationDate = creationDate;
    this.tags = tags;
    this.scenario = scenario;
    this.datasetId = datasetId;
    this.author = author;
    this.updateDate = updateDate;
    this.version = version;
    this.executionParameters = executionParameters;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ComposableTestCaseDto", generator = "Immutables")
  private final class InitShim {
    private byte creationDateBuildStage = STAGE_UNINITIALIZED;
    private Instant creationDate;

    Instant creationDate() {
      if (creationDateBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (creationDateBuildStage == STAGE_UNINITIALIZED) {
        creationDateBuildStage = STAGE_INITIALIZING;
        this.creationDate = Objects.requireNonNull(creationDateInitialize(), "creationDate");
        creationDateBuildStage = STAGE_INITIALIZED;
      }
      return this.creationDate;
    }

    void creationDate(Instant creationDate) {
      this.creationDate = creationDate;
      creationDateBuildStage = STAGE_INITIALIZED;
    }

    private byte authorBuildStage = STAGE_UNINITIALIZED;
    private String author;

    String author() {
      if (authorBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (authorBuildStage == STAGE_UNINITIALIZED) {
        authorBuildStage = STAGE_INITIALIZING;
        this.author = Objects.requireNonNull(authorInitialize(), "author");
        authorBuildStage = STAGE_INITIALIZED;
      }
      return this.author;
    }

    void author(String author) {
      this.author = author;
      authorBuildStage = STAGE_INITIALIZED;
    }

    private byte updateDateBuildStage = STAGE_UNINITIALIZED;
    private Instant updateDate;

    Instant updateDate() {
      if (updateDateBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (updateDateBuildStage == STAGE_UNINITIALIZED) {
        updateDateBuildStage = STAGE_INITIALIZING;
        this.updateDate = Objects.requireNonNull(updateDateInitialize(), "updateDate");
        updateDateBuildStage = STAGE_INITIALIZED;
      }
      return this.updateDate;
    }

    void updateDate(Instant updateDate) {
      this.updateDate = updateDate;
      updateDateBuildStage = STAGE_INITIALIZED;
    }

    private byte versionBuildStage = STAGE_UNINITIALIZED;
    private Integer version;

    Integer version() {
      if (versionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (versionBuildStage == STAGE_UNINITIALIZED) {
        versionBuildStage = STAGE_INITIALIZING;
        this.version = Objects.requireNonNull(versionInitialize(), "version");
        versionBuildStage = STAGE_INITIALIZED;
      }
      return this.version;
    }

    void version(Integer version) {
      this.version = version;
      versionBuildStage = STAGE_INITIALIZED;
    }

    private byte executionParametersBuildStage = STAGE_UNINITIALIZED;
    private List<KeyValue> executionParameters;

    List<KeyValue> executionParameters() {
      if (executionParametersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (executionParametersBuildStage == STAGE_UNINITIALIZED) {
        executionParametersBuildStage = STAGE_INITIALIZING;
        this.executionParameters = createUnmodifiableList(false, createSafeList(executionParametersInitialize(), true, false));
        executionParametersBuildStage = STAGE_INITIALIZED;
      }
      return this.executionParameters;
    }

    void executionParameters(List<KeyValue> executionParameters) {
      this.executionParameters = executionParameters;
      executionParametersBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (creationDateBuildStage == STAGE_INITIALIZING) attributes.add("creationDate");
      if (authorBuildStage == STAGE_INITIALIZING) attributes.add("author");
      if (updateDateBuildStage == STAGE_INITIALIZING) attributes.add("updateDate");
      if (versionBuildStage == STAGE_INITIALIZING) attributes.add("version");
      if (executionParametersBuildStage == STAGE_INITIALIZING) attributes.add("executionParameters");
      return "Cannot build ComposableTestCaseDto, attribute initializers form cycle " + attributes;
    }
  }

  private Instant creationDateInitialize() {
    return ComposableTestCaseDto.super.creationDate();
  }

  private String authorInitialize() {
    return ComposableTestCaseDto.super.author();
  }

  private Instant updateDateInitialize() {
    return ComposableTestCaseDto.super.updateDate();
  }

  private Integer versionInitialize() {
    return ComposableTestCaseDto.super.version();
  }

  private List<KeyValue> executionParametersInitialize() {
    return ComposableTestCaseDto.super.executionParameters();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public Optional<String> id() {
    return Optional.ofNullable(id);
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty("title")
  @Override
  public String title() {
    return title;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public Optional<String> description() {
    return Optional.ofNullable(description);
  }

  /**
   * @return The value of the {@code creationDate} attribute
   */
  @JsonProperty("creationDate")
  @Override
  public Instant creationDate() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.creationDate()
        : this.creationDate;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty("tags")
  @Override
  public List<String> tags() {
    return tags;
  }

  /**
   * @return The value of the {@code scenario} attribute
   */
  @JsonProperty("scenario")
  @Override
  public ComposableTestCaseDto.ComposableScenarioDto scenario() {
    return scenario;
  }

  /**
   * @return The value of the {@code datasetId} attribute
   */
  @JsonProperty("datasetId")
  @Override
  public Optional<String> datasetId() {
    return Optional.ofNullable(datasetId);
  }

  /**
   * @return The value of the {@code author} attribute
   */
  @JsonProperty("author")
  @Override
  public String author() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.author()
        : this.author;
  }

  /**
   * @return The value of the {@code updateDate} attribute
   */
  @JsonProperty("updateDate")
  @Override
  public Instant updateDate() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.updateDate()
        : this.updateDate;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public Integer version() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.version()
        : this.version;
  }

  /**
   * @return The value of the {@code executionParameters} attribute
   */
  @JsonProperty("computedParameters")
  @Override
  public List<KeyValue> executionParameters() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.executionParameters()
        : this.executionParameters;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ComposableTestCaseDto#id() id} attribute.
   * @param value The value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposableTestCaseDto withId(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "id");
    if (Objects.equals(this.id, newValue)) return this;
    return new ImmutableComposableTestCaseDto(
        newValue,
        this.title,
        this.description,
        this.creationDate,
        this.tags,
        this.scenario,
        this.datasetId,
        this.author,
        this.updateDate,
        this.version,
        this.executionParameters);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ComposableTestCaseDto#id() id} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposableTestCaseDto withId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableComposableTestCaseDto(
        value,
        this.title,
        this.description,
        this.creationDate,
        this.tags,
        this.scenario,
        this.datasetId,
        this.author,
        this.updateDate,
        this.version,
        this.executionParameters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ComposableTestCaseDto#title() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposableTestCaseDto withTitle(String value) {
    String newValue = Objects.requireNonNull(value, "title");
    if (this.title.equals(newValue)) return this;
    return new ImmutableComposableTestCaseDto(
        this.id,
        newValue,
        this.description,
        this.creationDate,
        this.tags,
        this.scenario,
        this.datasetId,
        this.author,
        this.updateDate,
        this.version,
        this.executionParameters);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ComposableTestCaseDto#description() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposableTestCaseDto withDescription(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return new ImmutableComposableTestCaseDto(
        this.id,
        this.title,
        newValue,
        this.creationDate,
        this.tags,
        this.scenario,
        this.datasetId,
        this.author,
        this.updateDate,
        this.version,
        this.executionParameters);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ComposableTestCaseDto#description() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposableTestCaseDto withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableComposableTestCaseDto(
        this.id,
        this.title,
        value,
        this.creationDate,
        this.tags,
        this.scenario,
        this.datasetId,
        this.author,
        this.updateDate,
        this.version,
        this.executionParameters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ComposableTestCaseDto#creationDate() creationDate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for creationDate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposableTestCaseDto withCreationDate(Instant value) {
    if (this.creationDate == value) return this;
    Instant newValue = Objects.requireNonNull(value, "creationDate");
    return new ImmutableComposableTestCaseDto(
        this.id,
        this.title,
        this.description,
        newValue,
        this.tags,
        this.scenario,
        this.datasetId,
        this.author,
        this.updateDate,
        this.version,
        this.executionParameters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ComposableTestCaseDto#tags() tags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposableTestCaseDto withTags(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableComposableTestCaseDto(
        this.id,
        this.title,
        this.description,
        this.creationDate,
        newValue,
        this.scenario,
        this.datasetId,
        this.author,
        this.updateDate,
        this.version,
        this.executionParameters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ComposableTestCaseDto#tags() tags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposableTestCaseDto withTags(Iterable<String> elements) {
    if (this.tags == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableComposableTestCaseDto(
        this.id,
        this.title,
        this.description,
        this.creationDate,
        newValue,
        this.scenario,
        this.datasetId,
        this.author,
        this.updateDate,
        this.version,
        this.executionParameters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ComposableTestCaseDto#scenario() scenario} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scenario
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposableTestCaseDto withScenario(ComposableTestCaseDto.ComposableScenarioDto value) {
    if (this.scenario == value) return this;
    ComposableTestCaseDto.ComposableScenarioDto newValue = Objects.requireNonNull(value, "scenario");
    return new ImmutableComposableTestCaseDto(
        this.id,
        this.title,
        this.description,
        this.creationDate,
        this.tags,
        newValue,
        this.datasetId,
        this.author,
        this.updateDate,
        this.version,
        this.executionParameters);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ComposableTestCaseDto#datasetId() datasetId} attribute.
   * @param value The value for datasetId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposableTestCaseDto withDatasetId(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "datasetId");
    if (Objects.equals(this.datasetId, newValue)) return this;
    return new ImmutableComposableTestCaseDto(
        this.id,
        this.title,
        this.description,
        this.creationDate,
        this.tags,
        this.scenario,
        newValue,
        this.author,
        this.updateDate,
        this.version,
        this.executionParameters);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ComposableTestCaseDto#datasetId() datasetId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datasetId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposableTestCaseDto withDatasetId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.datasetId, value)) return this;
    return new ImmutableComposableTestCaseDto(
        this.id,
        this.title,
        this.description,
        this.creationDate,
        this.tags,
        this.scenario,
        value,
        this.author,
        this.updateDate,
        this.version,
        this.executionParameters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ComposableTestCaseDto#author() author} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for author
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposableTestCaseDto withAuthor(String value) {
    String newValue = Objects.requireNonNull(value, "author");
    if (this.author.equals(newValue)) return this;
    return new ImmutableComposableTestCaseDto(
        this.id,
        this.title,
        this.description,
        this.creationDate,
        this.tags,
        this.scenario,
        this.datasetId,
        newValue,
        this.updateDate,
        this.version,
        this.executionParameters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ComposableTestCaseDto#updateDate() updateDate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updateDate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposableTestCaseDto withUpdateDate(Instant value) {
    if (this.updateDate == value) return this;
    Instant newValue = Objects.requireNonNull(value, "updateDate");
    return new ImmutableComposableTestCaseDto(
        this.id,
        this.title,
        this.description,
        this.creationDate,
        this.tags,
        this.scenario,
        this.datasetId,
        this.author,
        newValue,
        this.version,
        this.executionParameters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ComposableTestCaseDto#version() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposableTestCaseDto withVersion(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "version");
    if (this.version.equals(newValue)) return this;
    return new ImmutableComposableTestCaseDto(
        this.id,
        this.title,
        this.description,
        this.creationDate,
        this.tags,
        this.scenario,
        this.datasetId,
        this.author,
        this.updateDate,
        newValue,
        this.executionParameters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ComposableTestCaseDto#executionParameters() executionParameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposableTestCaseDto withExecutionParameters(KeyValue... elements) {
    List<KeyValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableComposableTestCaseDto(
        this.id,
        this.title,
        this.description,
        this.creationDate,
        this.tags,
        this.scenario,
        this.datasetId,
        this.author,
        this.updateDate,
        this.version,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ComposableTestCaseDto#executionParameters() executionParameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of executionParameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposableTestCaseDto withExecutionParameters(Iterable<? extends KeyValue> elements) {
    if (this.executionParameters == elements) return this;
    List<KeyValue> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableComposableTestCaseDto(
        this.id,
        this.title,
        this.description,
        this.creationDate,
        this.tags,
        this.scenario,
        this.datasetId,
        this.author,
        this.updateDate,
        this.version,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableComposableTestCaseDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableComposableTestCaseDto
        && equalTo(0, (ImmutableComposableTestCaseDto) another);
  }

  private boolean equalTo(int synthetic, ImmutableComposableTestCaseDto another) {
    return Objects.equals(id, another.id)
        && title.equals(another.title)
        && Objects.equals(description, another.description)
        && creationDate.equals(another.creationDate)
        && tags.equals(another.tags)
        && scenario.equals(another.scenario)
        && Objects.equals(datasetId, another.datasetId)
        && author.equals(another.author)
        && updateDate.equals(another.updateDate)
        && version.equals(another.version)
        && executionParameters.equals(another.executionParameters);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code title}, {@code description}, {@code creationDate}, {@code tags}, {@code scenario}, {@code datasetId}, {@code author}, {@code updateDate}, {@code version}, {@code executionParameters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + title.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + creationDate.hashCode();
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + scenario.hashCode();
    h += (h << 5) + Objects.hashCode(datasetId);
    h += (h << 5) + author.hashCode();
    h += (h << 5) + updateDate.hashCode();
    h += (h << 5) + version.hashCode();
    h += (h << 5) + executionParameters.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ComposableTestCaseDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ComposableTestCaseDto{");
    if (id != null) {
      builder.append("id=").append(id);
    }
    if (builder.length() > 22) builder.append(", ");
    builder.append("title=").append(title);
    if (description != null) {
      builder.append(", ");
      builder.append("description=").append(description);
    }
    builder.append(", ");
    builder.append("creationDate=").append(creationDate);
    builder.append(", ");
    builder.append("tags=").append(tags);
    builder.append(", ");
    builder.append("scenario=").append(scenario);
    if (datasetId != null) {
      builder.append(", ");
      builder.append("datasetId=").append(datasetId);
    }
    builder.append(", ");
    builder.append("author=").append(author);
    builder.append(", ");
    builder.append("updateDate=").append(updateDate);
    builder.append(", ");
    builder.append("version=").append(version);
    builder.append(", ");
    builder.append("executionParameters=").append(executionParameters);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ComposableTestCaseDto", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ComposableTestCaseDto {
    @Nullable Optional<String> id = Optional.empty();
    @Nullable String title;
    @Nullable Optional<String> description = Optional.empty();
    @Nullable Instant creationDate;
    @Nullable List<String> tags = Collections.emptyList();
    @Nullable ComposableTestCaseDto.ComposableScenarioDto scenario;
    @Nullable Optional<String> datasetId = Optional.empty();
    @Nullable String author;
    @Nullable Instant updateDate;
    @Nullable Integer version;
    @Nullable List<KeyValue> executionParameters = Collections.emptyList();
    boolean executionParametersIsSet;
    @JsonProperty("id")
    public void setId(Optional<String> id) {
      this.id = id;
    }
    @JsonProperty("title")
    public void setTitle(String title) {
      this.title = title;
    }
    @JsonProperty("description")
    public void setDescription(Optional<String> description) {
      this.description = description;
    }
    @JsonProperty("creationDate")
    public void setCreationDate(Instant creationDate) {
      this.creationDate = creationDate;
    }
    @JsonProperty("tags")
    public void setTags(List<String> tags) {
      this.tags = tags;
    }
    @JsonProperty("scenario")
    public void setScenario(ComposableTestCaseDto.ComposableScenarioDto scenario) {
      this.scenario = scenario;
    }
    @JsonProperty("datasetId")
    public void setDatasetId(Optional<String> datasetId) {
      this.datasetId = datasetId;
    }
    @JsonProperty("author")
    public void setAuthor(String author) {
      this.author = author;
    }
    @JsonProperty("updateDate")
    public void setUpdateDate(Instant updateDate) {
      this.updateDate = updateDate;
    }
    @JsonProperty("version")
    public void setVersion(Integer version) {
      this.version = version;
    }
    @JsonProperty("computedParameters")
    public void setExecutionParameters(List<KeyValue> executionParameters) {
      this.executionParameters = executionParameters;
      this.executionParametersIsSet = true;
    }
    @Override
    public Optional<String> id() { throw new UnsupportedOperationException(); }
    @Override
    public String title() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> description() { throw new UnsupportedOperationException(); }
    @Override
    public Instant creationDate() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> tags() { throw new UnsupportedOperationException(); }
    @Override
    public ComposableTestCaseDto.ComposableScenarioDto scenario() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> datasetId() { throw new UnsupportedOperationException(); }
    @Override
    public String author() { throw new UnsupportedOperationException(); }
    @Override
    public Instant updateDate() { throw new UnsupportedOperationException(); }
    @Override
    public Integer version() { throw new UnsupportedOperationException(); }
    @Override
    public List<KeyValue> executionParameters() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableComposableTestCaseDto fromJson(Json json) {
    ImmutableComposableTestCaseDto.Builder builder = ImmutableComposableTestCaseDto.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.creationDate != null) {
      builder.creationDate(json.creationDate);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    if (json.scenario != null) {
      builder.scenario(json.scenario);
    }
    if (json.datasetId != null) {
      builder.datasetId(json.datasetId);
    }
    if (json.author != null) {
      builder.author(json.author);
    }
    if (json.updateDate != null) {
      builder.updateDate(json.updateDate);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.executionParametersIsSet) {
      builder.addAllExecutionParameters(json.executionParameters);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ComposableTestCaseDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ComposableTestCaseDto instance
   */
  public static ImmutableComposableTestCaseDto copyOf(ComposableTestCaseDto instance) {
    if (instance instanceof ImmutableComposableTestCaseDto) {
      return (ImmutableComposableTestCaseDto) instance;
    }
    return ImmutableComposableTestCaseDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableComposableTestCaseDto ImmutableComposableTestCaseDto}.
   * <pre>
   * ImmutableComposableTestCaseDto.builder()
   *    .id(String) // optional {@link ComposableTestCaseDto#id() id}
   *    .title(String) // required {@link ComposableTestCaseDto#title() title}
   *    .description(String) // optional {@link ComposableTestCaseDto#description() description}
   *    .creationDate(java.time.Instant) // optional {@link ComposableTestCaseDto#creationDate() creationDate}
   *    .addTags|addAllTags(String) // {@link ComposableTestCaseDto#tags() tags} elements
   *    .scenario(com.chutneytesting.component.scenario.api.dto.ComposableTestCaseDto.ComposableScenarioDto) // required {@link ComposableTestCaseDto#scenario() scenario}
   *    .datasetId(String) // optional {@link ComposableTestCaseDto#datasetId() datasetId}
   *    .author(String) // optional {@link ComposableTestCaseDto#author() author}
   *    .updateDate(java.time.Instant) // optional {@link ComposableTestCaseDto#updateDate() updateDate}
   *    .version(Integer) // optional {@link ComposableTestCaseDto#version() version}
   *    .addExecutionParameters|addAllExecutionParameters(com.chutneytesting.server.core.domain.tools.ui.KeyValue) // {@link ComposableTestCaseDto#executionParameters() executionParameters} elements
   *    .build();
   * </pre>
   * @return A new ImmutableComposableTestCaseDto builder
   */
  public static ImmutableComposableTestCaseDto.Builder builder() {
    return new ImmutableComposableTestCaseDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableComposableTestCaseDto ImmutableComposableTestCaseDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ComposableTestCaseDto", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TITLE = 0x1L;
    private static final long INIT_BIT_SCENARIO = 0x2L;
    private static final long OPT_BIT_EXECUTION_PARAMETERS = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private @Nullable String id;
    private @Nullable String title;
    private @Nullable String description;
    private @Nullable Instant creationDate;
    private List<String> tags = new ArrayList<String>();
    private @Nullable ComposableTestCaseDto.ComposableScenarioDto scenario;
    private @Nullable String datasetId;
    private @Nullable String author;
    private @Nullable Instant updateDate;
    private @Nullable Integer version;
    private List<KeyValue> executionParameters = new ArrayList<KeyValue>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ComposableTestCaseDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ComposableTestCaseDto instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> idOptional = instance.id();
      if (idOptional.isPresent()) {
        id(idOptional);
      }
      title(instance.title());
      Optional<String> descriptionOptional = instance.description();
      if (descriptionOptional.isPresent()) {
        description(descriptionOptional);
      }
      creationDate(instance.creationDate());
      addAllTags(instance.tags());
      scenario(instance.scenario());
      Optional<String> datasetIdOptional = instance.datasetId();
      if (datasetIdOptional.isPresent()) {
        datasetId(datasetIdOptional);
      }
      author(instance.author());
      updateDate(instance.updateDate());
      version(instance.version());
      addAllExecutionParameters(instance.executionParameters());
      return this;
    }

    /**
     * Initializes the optional value {@link ComposableTestCaseDto#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the optional value {@link ComposableTestCaseDto#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(Optional<String> id) {
      this.id = id.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ComposableTestCaseDto#title() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("title")
    public final Builder title(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Initializes the optional value {@link ComposableTestCaseDto#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link ComposableTestCaseDto#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ComposableTestCaseDto#creationDate() creationDate} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ComposableTestCaseDto#creationDate() creationDate}.</em>
     * @param creationDate The value for creationDate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("creationDate")
    public final Builder creationDate(Instant creationDate) {
      this.creationDate = Objects.requireNonNull(creationDate, "creationDate");
      return this;
    }

    /**
     * Adds one element to {@link ComposableTestCaseDto#tags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTags(String element) {
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link ComposableTestCaseDto#tags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTags(String... elements) {
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ComposableTestCaseDto#tags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("tags")
    public final Builder tags(Iterable<String> elements) {
      this.tags.clear();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link ComposableTestCaseDto#tags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTags(Iterable<String> elements) {
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ComposableTestCaseDto#scenario() scenario} attribute.
     * @param scenario The value for scenario 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("scenario")
    public final Builder scenario(ComposableTestCaseDto.ComposableScenarioDto scenario) {
      this.scenario = Objects.requireNonNull(scenario, "scenario");
      initBits &= ~INIT_BIT_SCENARIO;
      return this;
    }

    /**
     * Initializes the optional value {@link ComposableTestCaseDto#datasetId() datasetId} to datasetId.
     * @param datasetId The value for datasetId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder datasetId(String datasetId) {
      this.datasetId = Objects.requireNonNull(datasetId, "datasetId");
      return this;
    }

    /**
     * Initializes the optional value {@link ComposableTestCaseDto#datasetId() datasetId} to datasetId.
     * @param datasetId The value for datasetId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("datasetId")
    public final Builder datasetId(Optional<String> datasetId) {
      this.datasetId = datasetId.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ComposableTestCaseDto#author() author} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ComposableTestCaseDto#author() author}.</em>
     * @param author The value for author 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("author")
    public final Builder author(String author) {
      this.author = Objects.requireNonNull(author, "author");
      return this;
    }

    /**
     * Initializes the value for the {@link ComposableTestCaseDto#updateDate() updateDate} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ComposableTestCaseDto#updateDate() updateDate}.</em>
     * @param updateDate The value for updateDate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("updateDate")
    public final Builder updateDate(Instant updateDate) {
      this.updateDate = Objects.requireNonNull(updateDate, "updateDate");
      return this;
    }

    /**
     * Initializes the value for the {@link ComposableTestCaseDto#version() version} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ComposableTestCaseDto#version() version}.</em>
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("version")
    public final Builder version(Integer version) {
      this.version = Objects.requireNonNull(version, "version");
      return this;
    }

    /**
     * Adds one element to {@link ComposableTestCaseDto#executionParameters() executionParameters} list.
     * @param element A executionParameters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExecutionParameters(KeyValue element) {
      this.executionParameters.add(Objects.requireNonNull(element, "executionParameters element"));
      optBits |= OPT_BIT_EXECUTION_PARAMETERS;
      return this;
    }

    /**
     * Adds elements to {@link ComposableTestCaseDto#executionParameters() executionParameters} list.
     * @param elements An array of executionParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExecutionParameters(KeyValue... elements) {
      for (KeyValue element : elements) {
        this.executionParameters.add(Objects.requireNonNull(element, "executionParameters element"));
      }
      optBits |= OPT_BIT_EXECUTION_PARAMETERS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ComposableTestCaseDto#executionParameters() executionParameters} list.
     * @param elements An iterable of executionParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("computedParameters")
    public final Builder executionParameters(Iterable<? extends KeyValue> elements) {
      this.executionParameters.clear();
      return addAllExecutionParameters(elements);
    }

    /**
     * Adds elements to {@link ComposableTestCaseDto#executionParameters() executionParameters} list.
     * @param elements An iterable of executionParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExecutionParameters(Iterable<? extends KeyValue> elements) {
      for (KeyValue element : elements) {
        this.executionParameters.add(Objects.requireNonNull(element, "executionParameters element"));
      }
      optBits |= OPT_BIT_EXECUTION_PARAMETERS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableComposableTestCaseDto ImmutableComposableTestCaseDto}.
     * @return An immutable instance of ComposableTestCaseDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableComposableTestCaseDto build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableComposableTestCaseDto(this);
    }

    private boolean executionParametersIsSet() {
      return (optBits & OPT_BIT_EXECUTION_PARAMETERS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TITLE) != 0) attributes.add("title");
      if ((initBits & INIT_BIT_SCENARIO) != 0) attributes.add("scenario");
      return "Cannot build ComposableTestCaseDto, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
