/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.infra;

import com.chutneytesting.component.ComposableIdUtils;
import com.chutneytesting.component.execution.domain.ExecutableComposedStep;
import com.chutneytesting.component.execution.domain.ExecutableStepRepository;
import com.chutneytesting.component.scenario.domain.AlreadyExistingComposableStepException;
import com.chutneytesting.component.scenario.domain.ComposableStep;
import com.chutneytesting.component.scenario.domain.ComposableStepNotFoundException;
import com.chutneytesting.component.scenario.domain.ComposableStepRepository;
import com.chutneytesting.component.scenario.domain.ParentStepId;
import com.chutneytesting.component.scenario.infra.ExecutableComposedStepMapper;
import com.chutneytesting.component.scenario.infra.OrientComposableStepMapper;
import com.chutneytesting.component.scenario.infra.orient.OrientComponentDB;
import com.chutneytesting.component.scenario.infra.orient.OrientUtils;
import com.chutneytesting.component.scenario.infra.wrapper.StepVertex;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class OrientComposableStepRepository
implements ComposableStepRepository,
ExecutableStepRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrientComposableStepRepository.class);
    private final ODatabasePool componentDBPool;
    private final ExecutableComposedStepMapper composedStepMapper;
    private static final String QUERY_SELECT_ALL = "SELECT @rid FROM FuncStep";
    private static final String FIND_PARENTS_STEP = "select @rid, name, title, @class from (TRAVERSE in(Denote) FROM ?) where $depth = 1";

    public OrientComposableStepRepository(OrientComponentDB orientComponentDB, ExecutableComposedStepMapper mapper) {
        this.componentDBPool = orientComponentDB.dbPool();
        this.composedStepMapper = mapper;
    }

    @Override
    public String save(ComposableStep composableStep) {
        LOGGER.debug("Saving component : " + composableStep.name);
        ODatabaseSession dbSession = null;
        try {
            dbSession = this.componentDBPool.acquire();
            dbSession.begin();
            OVertex savedFStep = this.save(composableStep, dbSession);
            dbSession.commit();
            LOGGER.debug("Saved component : " + savedFStep.toString());
            String string = ComposableIdUtils.toExternalId(savedFStep.getIdentity().toString(null).toString());
            return string;
        }
        catch (ORecordDuplicatedException e) {
            OrientUtils.rollback(dbSession);
            throw new AlreadyExistingComposableStepException(composableStep);
        }
        catch (Exception e) {
            OrientUtils.rollback(dbSession);
            throw new RuntimeException(e);
        }
        finally {
            OrientUtils.close(dbSession);
        }
    }

    @Override
    public ComposableStep findById(String recordId) {
        String internalId = ComposableIdUtils.toInternalId(recordId);
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OVertex element = (OVertex)OrientUtils.load(internalId, dbSession).orElseThrow(() -> new ComposableStepNotFoundException(internalId));
            ComposableStep composableStep = OrientComposableStepMapper.vertexToComposableStep(StepVertex.builder().from(element).build());
            return composableStep;
        }
    }

    @Override
    public ExecutableComposedStep findExecutableById(String recordId) {
        ComposableStep composableStep = this.findById(recordId);
        return this.composedStepMapper.composableToExecutable(composableStep);
    }

    @Override
    public void deleteById(String recordId) {
        String internalId = ComposableIdUtils.toInternalId(recordId);
        ODatabaseSession dbSession = null;
        try {
            dbSession = this.componentDBPool.acquire();
            dbSession.begin();
            OrientUtils.deleteVertex(internalId, dbSession);
            dbSession.commit();
            LOGGER.debug("Removed component : " + internalId);
        }
        catch (Exception e) {
            OrientUtils.rollback(dbSession);
            throw new RuntimeException(e);
        }
        finally {
            OrientUtils.close(dbSession);
        }
    }

    @Override
    public List<ComposableStep> findAll() {
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OResultSet allSteps = dbSession.query(QUERY_SELECT_ALL, new Object[0]);
            List<ComposableStep> list = Lists.newArrayList((Iterator)allSteps).stream().map(rs -> {
                OVertex element = (OVertex)dbSession.load((ORID)new ORecordId(rs.getProperty("@rid").toString()));
                return OrientComposableStepMapper.vertexToComposableStep(StepVertex.builder().from(element).build());
            }).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<ParentStepId> findParents(String stepId) {
        block14: {
            String internalId = ComposableIdUtils.toInternalId(stepId);
            try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
                Optional<OElement> stepRecord = OrientUtils.load(internalId, dbSession);
                if (!stepRecord.isPresent()) break block14;
                ArrayList<ParentStepId> funcStepIds = new ArrayList<ParentStepId>();
                try (OResultSet rs = dbSession.query(FIND_PARENTS_STEP, new Object[]{stepRecord.get().getIdentity()});){
                    while (rs.hasNext()) {
                        OResult res = rs.next();
                        if (res.getProperty("@class").equals("FuncStep")) {
                            funcStepIds.add(new ParentStepId(ComposableIdUtils.toExternalId(res.getProperty("@rid").toString()), (String)res.getProperty("name"), false));
                            continue;
                        }
                        funcStepIds.add(new ParentStepId(ComposableIdUtils.toExternalId(res.getProperty("@rid").toString()), (String)res.getProperty("title"), true));
                    }
                }
                ArrayList<ParentStepId> arrayList = funcStepIds;
                return arrayList;
            }
        }
        throw new ComposableStepNotFoundException(stepId);
    }

    private OVertex save(ComposableStep composableStep, ODatabaseSession dbSession) {
        String internalId = ComposableIdUtils.toInternalId(composableStep.id);
        Optional<OElement> stepRecord = OrientUtils.load(internalId, dbSession);
        OVertex oVertex = (OVertex)stepRecord.orElse((OElement)dbSession.newVertex("FuncStep"));
        StepVertex stepVertex = OrientComposableStepMapper.composableStepToVertex(composableStep, oVertex, dbSession);
        return stepVertex.save(dbSession);
    }
}

