/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.api.dto;

import com.chutneytesting.component.scenario.api.dto.ImmutableComposableStepDto;
import com.chutneytesting.component.scenario.api.dto.ImmutableStrategyDto;
import com.chutneytesting.component.scenario.api.dto.StrategyDto;
import com.chutneytesting.server.core.domain.tools.ui.KeyValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableComposableStepDto.class)
@JsonDeserialize(as=ImmutableComposableStepDto.class)
@Value.Immutable
@Value.Style(jdkOnly=true)
public interface ComposableStepDto {
    public static final Comparator<ComposableStepDto> stepDtoComparator = Comparator.comparing(ComposableStepDto::name, String.CASE_INSENSITIVE_ORDER);

    public Optional<String> id();

    public String name();

    @Value.Default
    default public StrategyDto strategy() {
        return ImmutableStrategyDto.builder().build();
    }

    @Value.Default
    default public StepUsage usage() {
        return StepUsage.STEP;
    }

    public Optional<String> task();

    @Value.Default
    default public List<ComposableStepDto> steps() {
        return Collections.emptyList();
    }

    @JsonProperty(value="parameters")
    @Value.Default
    default public List<KeyValue> defaultParameters() {
        return Collections.emptyList();
    }

    @JsonProperty(value="computedParameters")
    @Value.Default
    default public List<KeyValue> executionParameters() {
        return Collections.emptyList();
    }

    @Value.Default
    default public List<String> tags() {
        return Collections.emptyList();
    }

    public static enum StepUsage {
        STEP,
        GIVEN,
        WHEN,
        THEN;

    }
}

