/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.api;

import com.chutneytesting.component.scenario.api.ComposableStepMapper;
import com.chutneytesting.component.scenario.api.ParentStepMapper;
import com.chutneytesting.component.scenario.api.dto.ComposableStepDto;
import com.chutneytesting.component.scenario.api.dto.ParentsStepDto;
import com.chutneytesting.component.scenario.domain.ComposableStepRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/steps/v1"})
@CrossOrigin(origins={"*"})
public class StepController {
    static final String BASE_URL = "/api/steps/v1";
    private final ComposableStepRepository composableStepRepository;

    public StepController(ComposableStepRepository composableStepRepository) {
        this.composableStepRepository = composableStepRepository;
    }

    @PreAuthorize(value="hasAuthority('COMPONENT_WRITE')")
    @PostMapping(path={""}, produces={"application/json"})
    public String save(@RequestBody ComposableStepDto step) {
        return this.composableStepRepository.save(ComposableStepMapper.fromDto(step));
    }

    @PreAuthorize(value="hasAuthority('COMPONENT_WRITE')")
    @DeleteMapping(path={"/{stepId}"})
    public void deleteById(@PathVariable String stepId) {
        this.composableStepRepository.deleteById(stepId);
    }

    @PreAuthorize(value="hasAuthority('COMPONENT_READ') or hasAuthority('SCENARIO_WRITE')")
    @GetMapping(path={"/all"}, produces={"application/json"})
    public List<ComposableStepDto> findAll() {
        return this.composableStepRepository.findAll().stream().map(ComposableStepMapper::toDto).sorted(ComposableStepDto.stepDtoComparator).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('COMPONENT_READ')")
    @GetMapping(path={"/{stepId}/parents"}, produces={"application/json"})
    public ParentsStepDto findParents(@PathVariable String stepId) {
        return ParentStepMapper.toDto(this.composableStepRepository.findParents(stepId));
    }

    @PreAuthorize(value="hasAuthority('COMPONENT_READ')")
    @GetMapping(path={"/{stepId}"}, produces={"application/json"})
    public ComposableStepDto findById(@PathVariable String stepId) {
        return ComposableStepMapper.toDto(this.composableStepRepository.findById(stepId));
    }
}

