/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.api;

import com.chutneytesting.component.scenario.api.ComposableStrategyType;
import com.chutneytesting.component.scenario.api.dto.ComposableStepDto;
import com.chutneytesting.component.scenario.api.dto.ImmutableComposableStepDto;
import com.chutneytesting.component.scenario.api.dto.ImmutableStrategyDto;
import com.chutneytesting.component.scenario.api.dto.StrategyDto;
import com.chutneytesting.component.scenario.domain.ComposableStep;
import com.chutneytesting.component.scenario.domain.Strategy;
import com.chutneytesting.server.core.domain.tools.ui.KeyValue;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ComposableStepMapper {
    public static ComposableStepDto toDto(ComposableStep composableStep) {
        ImmutableComposableStepDto.Builder builder = ImmutableComposableStepDto.builder().id(composableStep.id).name(composableStep.name).tags(composableStep.tags);
        composableStep.implementation.ifPresent(builder::task);
        composableStep.steps.forEach(step -> builder.addSteps(ComposableStepMapper.toDto(step)));
        builder.defaultParameters(KeyValue.fromMap(composableStep.defaultParameters));
        builder.strategy(ComposableStepMapper.toDto(composableStep.strategy));
        builder.addAllExecutionParameters(KeyValue.fromMap(composableStep.executionParameters));
        return builder.build();
    }

    private static StrategyDto toDto(Strategy strategy) {
        return ImmutableStrategyDto.builder().type(ComposableStrategyType.fromEngineType((String)strategy.type).name).putAllParameters(ComposableStepMapper.toDto(strategy.parameters)).build();
    }

    private static Map<String, Object> toDto(Map<String, Object> parameters) {
        HashMap<String, Object> parametersDto = new HashMap<String, Object>(parameters);
        if (parametersDto.containsKey("timeOut")) {
            parametersDto.put("timeout", parameters.get("timeOut"));
            parametersDto.remove("timeOut");
        }
        if (parametersDto.containsKey("retryDelay")) {
            parametersDto.put("delay", parameters.get("retryDelay"));
            parametersDto.remove("retryDelay");
        }
        return parametersDto;
    }

    public static ComposableStep fromDto(ComposableStepDto dto) {
        return ComposableStep.builder().withId(dto.id().orElse("")).withName(dto.name()).withStrategy(ComposableStepMapper.fromDto(dto.strategy())).withImplementation(dto.task().orElse("")).withSteps(dto.steps().stream().map(ComposableStepMapper::fromDto).collect(Collectors.toList())).withDefaultParameters(KeyValue.toMap(dto.defaultParameters())).withExecutionParameters(KeyValue.toMap(dto.executionParameters())).withTags(dto.tags().stream().map(String::trim).filter(t -> !t.isEmpty()).collect(Collectors.toList())).build();
    }

    public static Map<String, Object> fromDtoParameters(Map<String, Object> parametersDto) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(parametersDto);
        if (parameters.containsKey("timeout")) {
            parameters.put("timeOut", parametersDto.get("timeout"));
            parameters.remove("timeout");
        }
        if (parameters.containsKey("delay")) {
            parameters.put("retryDelay", parametersDto.get("delay"));
            parameters.remove("delay");
        }
        return parameters;
    }

    private static Strategy fromDto(StrategyDto strategyDto) {
        return new Strategy(ComposableStrategyType.fromName((String)strategyDto.type()).engineType, ComposableStepMapper.fromDtoParameters(strategyDto.parameters()));
    }
}

