/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component;

import java.util.Optional;

public final class ComposableIdUtils {
    public static String toExternalId(String id) {
        if (ComposableIdUtils.isComposableDomainId(Optional.ofNullable(id).orElse(""))) {
            return id.replace("#", "").replace(":", "-");
        }
        return id;
    }

    public static String toInternalId(String id) {
        return Optional.ofNullable(id).map(s -> {
            if (ComposableIdUtils.isComposableFrontId(s)) {
                return "#" + s.replace("-", ":");
            }
            return s;
        }).orElse("");
    }

    public static boolean isComposableFrontId(String frontId) {
        return frontId.contains("-");
    }

    private static boolean isComposableDomainId(String testCaseId) {
        return testCaseId.contains("#") && testCaseId.contains(":");
    }
}

