/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ActionExecutionResult {
    public final Status status;
    public final Map<String, Object> outputs;

    private ActionExecutionResult(Status status, Map<String, ?> outputs) {
        this.status = status;
        this.outputs = Collections.unmodifiableMap(outputs);
    }

    private ActionExecutionResult(Status status) {
        this(status, Collections.emptyMap());
    }

    public static ActionExecutionResult ok() {
        return new ActionExecutionResult(Status.Success);
    }

    public static ActionExecutionResult ok(Map<String, ?> outputs) {
        return new ActionExecutionResult(Status.Success, outputs);
    }

    public static ActionExecutionResult ok(String key, Object value) {
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        outputs.put(key, value);
        return new ActionExecutionResult(Status.Success, outputs);
    }

    public static ActionExecutionResult ko() {
        return new ActionExecutionResult(Status.Failure);
    }

    public static ActionExecutionResult ko(Map<String, ?> outputs) {
        return new ActionExecutionResult(Status.Failure, outputs);
    }

    public static enum Status {
        Success,
        Failure;

    }
}

