/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.selenium;

import com.chutneytesting.action.selenium.SeleniumAction;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;

public class SeleniumSetBrowserSizeAction
extends SeleniumAction {
    private final Integer width;
    private final Integer height;

    public SeleniumSetBrowserSizeAction(Logger logger, @Input(value="web-driver") WebDriver webDriver, @Input(value="width") Integer width, @Input(value="height") Integer height) {
        super(logger, webDriver);
        this.width = width;
        this.height = height;
    }

    @Override
    public ActionExecutionResult executeSeleniumAction() {
        try {
            this.webDriver.manage().window().setPosition(new Point(0, 0));
            this.webDriver.manage().window().setSize(new Dimension(this.width.intValue(), this.height.intValue()));
            this.logger.info("Set browser window size to " + this.width + "x" + this.height);
        }
        catch (NumberFormatException e) {
            this.logger.error("Failed to parse width: " + this.width + " or height: " + this.height);
            return ActionExecutionResult.ko();
        }
        return ActionExecutionResult.ok();
    }
}

