/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.radius;

import com.chutneytesting.action.radius.RadiusHelper;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.tinyradius.packet.AccessRequest;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusClient;
import org.tinyradius.util.RadiusException;

public class RadiusAuthenticateAction
implements Action {
    private final Logger logger;
    private final Target target;
    private final String protocol;
    private final String userName;
    private final String userPassword;
    private final Map<String, String> attributes;

    public RadiusAuthenticateAction(Logger logger, Target target, @Input(value="userName") String userName, @Input(value="userPassword") String userPassword, @Input(value="protocol") String protocol, @Input(value="attributes") Map<String, String> attributes) {
        this.logger = logger;
        this.target = target;
        this.userName = userName;
        this.userPassword = userPassword;
        this.protocol = RadiusHelper.getRadiusProtocol(protocol);
        this.attributes = Optional.ofNullable(attributes).orElse(Collections.emptyMap());
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.targetValidation((Target)this.target), RadiusHelper.radiusTargetPropertiesValidation(this.target), RadiusHelper.radiusTargetPortPropertiesValidation(this.target), ActionValidatorsUtils.notBlankStringValidation((String)this.userName, (String)"userName"), ActionValidatorsUtils.notBlankStringValidation((String)this.userPassword, (String)"userPassword")});
    }

    public ActionExecutionResult execute() {
        AccessRequest accessRequest = new AccessRequest(this.userName, this.userPassword);
        accessRequest.setAuthProtocol(this.protocol);
        this.attributes.forEach((arg_0, arg_1) -> ((AccessRequest)accessRequest).addAttribute(arg_0, arg_1));
        RadiusClient client = RadiusHelper.createRadiusClient(this.target);
        try {
            RadiusPacket response = client.authenticate(accessRequest);
            if (response == null) {
                this.logger.error("Authenticate failed. Response is null");
                return ActionExecutionResult.ko();
            }
            HashMap<String, RadiusPacket> outputs = new HashMap<String, RadiusPacket>();
            outputs.put("radiusResponse", response);
            this.logger.info("Access request for [" + this.userName + "] response type : " + response.getPacketTypeName());
            String ip = RadiusHelper.silentGetAttribute(response, "Framed-IP-Address");
            if (!ip.isBlank()) {
                this.logger.info("Response ip address " + ip);
            }
            return ActionExecutionResult.ok(outputs);
        }
        catch (IOException | RadiusException e) {
            this.logger.error(e);
            return ActionExecutionResult.ko();
        }
    }
}

