/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.micrometer;

import com.chutneytesting.action.micrometer.MicrometerActionHelper;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.validation.Validator;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class MicrometerTimerStopAction
implements Action {
    protected static final String OUTPUT_TIMER_SAMPLE_DURATION = "micrometerTimerSampleDuration";
    private final Logger logger;
    private final Timer.Sample sample;
    private final Timer timer;
    private final String timeunit;

    public MicrometerTimerStopAction(Logger logger, @Input(value="sample") Timer.Sample sample, @Input(value="timer") Timer timer, @Input(value="timeunit") String timeunit) {
        this.logger = logger;
        this.sample = sample;
        this.timer = timer;
        this.timeunit = Optional.ofNullable(timeunit).orElse(TimeUnit.SECONDS.name());
    }

    public List<String> validateInputs() {
        Validator sampleValidation = Validator.of((Object)this.sample).validate(Objects::nonNull, "No sample provided");
        Validator timerValidation = Validator.of((Object)this.timer).validate(Objects::nonNull, "No timer provided");
        Validator timeunitValidation = Validator.of((Object)this.timeunit).validate(t -> TimeUnit.valueOf(this.timeunit), noException -> true, "Timeunit not parsable");
        return Validator.getErrorsFrom((Validator[])new Validator[]{sampleValidation, timerValidation, timeunitValidation});
    }

    public ActionExecutionResult execute() {
        try {
            long duration = this.sample.stop(this.timer);
            Duration durationObj = Duration.of(duration, ChronoUnit.NANOS);
            this.logger.info("Timer sample stopped and last for " + durationObj);
            MicrometerActionHelper.logTimerState(this.logger, this.timer, TimeUnit.valueOf(this.timeunit));
            return ActionExecutionResult.ok(MicrometerActionHelper.toOutputs(OUTPUT_TIMER_SAMPLE_DURATION, durationObj));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return ActionExecutionResult.ko();
        }
    }
}

