/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.micrometer;

import com.chutneytesting.action.micrometer.MicrometerActionHelper;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.validation.Validator;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class MicrometerTimerAction
implements Action {
    protected static final String OUTPUT_TIMER = "micrometerTimer";
    private final Logger logger;
    private final String name;
    private final String description;
    private final List<String> tags;
    private final String bufferLength;
    private final String expiry;
    private final String maxValue;
    private final String minValue;
    private final String percentilePrecision;
    private final Boolean publishPercentilesHistogram;
    private final String percentiles;
    private final String sla;
    private Timer timer;
    private final MeterRegistry registry;
    private final String timeunit;
    private final String record;

    public MicrometerTimerAction(Logger logger, @Input(value="name") String name, @Input(value="description") String description, @Input(value="tags") List<String> tags, @Input(value="bufferLength") String bufferLength, @Input(value="expiry") String expiry, @Input(value="maxValue") String maxValue, @Input(value="minValue") String minValue, @Input(value="percentilePrecision") String percentilePrecision, @Input(value="publishPercentilesHistogram") Boolean publishPercentilesHistogram, @Input(value="percentiles") String percentiles, @Input(value="sla") String sla, @Input(value="timer") Timer timer, @Input(value="registry") MeterRegistry registry, @Input(value="timeunit") String timeunit, @Input(value="record") String record) {
        this.logger = logger;
        this.name = name;
        this.description = description;
        this.tags = tags;
        this.bufferLength = bufferLength;
        this.expiry = expiry;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.percentilePrecision = percentilePrecision;
        this.publishPercentilesHistogram = publishPercentilesHistogram;
        this.percentiles = percentiles;
        this.sla = sla;
        this.timeunit = Optional.ofNullable(timeunit).orElse(TimeUnit.SECONDS.name());
        this.record = record;
        this.timer = timer;
        this.registry = Optional.ofNullable(registry).orElse((MeterRegistry)Metrics.globalRegistry);
    }

    public List<String> validateInputs() {
        Validator metricNameValidation = Validator.of(null).validate(a -> this.name != null || this.timer != null, "name and timer cannot be both null");
        return Validator.getErrorsFrom((Validator[])new Validator[]{metricNameValidation, MicrometerActionHelper.integerStringValidation(this.bufferLength, "bufferLength"), MicrometerActionHelper.integerStringValidation(this.percentilePrecision, "percentilePrecision"), MicrometerActionHelper.durationStringValidation(this.maxValue, "maxValue"), MicrometerActionHelper.durationStringValidation(this.minValue, "minValue"), MicrometerActionHelper.durationStringValidation(this.record, "record"), MicrometerActionHelper.durationStringValidation(this.expiry, "expiry"), MicrometerActionHelper.percentilesListValidation(this.percentiles), MicrometerActionHelper.slaListToDoublesValidation(this.sla)});
    }

    public ActionExecutionResult execute() {
        try {
            this.timer = Optional.ofNullable(this.timer).orElseGet(() -> this.retrieveTimer(this.registry));
            if (this.record != null) {
                this.timer.record(MicrometerActionHelper.parseDuration(this.record));
                this.logger.info("Timer updated by " + this.record);
            }
            MicrometerActionHelper.logTimerState(this.logger, this.timer, TimeUnit.valueOf(this.timeunit));
            return ActionExecutionResult.ok(MicrometerActionHelper.toOutputs(OUTPUT_TIMER, this.timer));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return ActionExecutionResult.ko();
        }
    }

    private Timer retrieveTimer(MeterRegistry registry) {
        Timer.Builder builder = Timer.builder((String)Objects.requireNonNull(this.name)).description(this.description).distributionStatisticBufferLength(MicrometerActionHelper.parseIntOrNull(this.bufferLength)).distributionStatisticExpiry(MicrometerActionHelper.parseDurationOrNull(this.expiry)).maximumExpectedValue(MicrometerActionHelper.parseDurationOrNull(this.maxValue)).minimumExpectedValue(MicrometerActionHelper.parseDurationOrNull(this.minValue)).percentilePrecision(MicrometerActionHelper.parseIntOrNull(this.percentilePrecision)).publishPercentileHistogram(this.publishPercentilesHistogram).publishPercentiles(MicrometerActionHelper.parseMapOrNull(this.percentiles, MicrometerActionHelper::parsePercentilesList)).serviceLevelObjectives(MicrometerActionHelper.parseMapOrNull(this.sla, MicrometerActionHelper::parseSlaListToDurations));
        Optional.ofNullable(this.tags).ifPresent(t -> builder.tags(t.toArray(new String[0])));
        return builder.register(registry);
    }
}

