/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.kafka;

import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.validation.Validator;
import java.util.List;
import java.util.Objects;
import org.springframework.kafka.test.EmbeddedKafkaBroker;

public class KafkaBrokerStopAction
implements Action {
    private final Logger logger;
    private final EmbeddedKafkaBroker broker;

    public KafkaBrokerStopAction(Logger logger, @Input(value="broker") EmbeddedKafkaBroker broker) {
        this.logger = logger;
        this.broker = broker;
    }

    public List<String> validateInputs() {
        Validator embeddedKafkaBrokerValidation = Validator.of((Object)this.broker).validate(Objects::nonNull, "No broker provided");
        return Validator.getErrorsFrom((Validator[])new Validator[]{embeddedKafkaBrokerValidation});
    }

    public ActionExecutionResult execute() {
        this.logger.info("Call Kafka broker shutdown");
        this.broker.destroy();
        return ActionExecutionResult.ok();
    }
}

