/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.jms;

import com.chutneytesting.action.jms.JmsConnectionFactory;
import com.chutneytesting.action.jms.UncheckedJmsException;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.chutneytesting.tools.CloseableResource;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;

public class JmsSenderAction
implements Action {
    private final Target target;
    private final Logger logger;
    private final String destination;
    private final String body;
    private final Map<String, String> headers;
    private final JmsConnectionFactory jmsConnectionFactory = new JmsConnectionFactory();

    public JmsSenderAction(Target target, Logger logger, @Input(value="destination") String destination, @Input(value="body") String body, @Input(value="headers") Map<String, String> headers) {
        this.target = target;
        this.logger = logger;
        this.destination = destination;
        this.body = body;
        this.headers = headers != null ? headers : Collections.emptyMap();
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.targetValidation((Target)this.target), ActionValidatorsUtils.notBlankStringValidation((String)this.destination, (String)"destination"), ActionValidatorsUtils.notBlankStringValidation((String)this.body, (String)"body")});
    }

    public ActionExecutionResult execute() {
        ActionExecutionResult actionExecutionResult;
        block8: {
            CloseableResource<JmsConnectionFactory.MessageSender> producer = this.jmsConnectionFactory.getMessageProducer(this.target, this.destination);
            try {
                ((JmsConnectionFactory.MessageSender)producer.getResource()).send(this.body, this.headers);
                this.logger.info("Successfully sent message on " + this.destination + " to " + this.target.name() + " (" + this.target.uri().toString() + ")");
                actionExecutionResult = ActionExecutionResult.ok();
                if (producer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (producer != null) {
                        try {
                            producer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UncheckedJmsException | JMSException e) {
                    this.logger.error(e);
                    return ActionExecutionResult.ko();
                }
            }
            producer.close();
        }
        return actionExecutionResult;
    }
}

