/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.http;

import com.chutneytesting.action.http.HttpActionHelper;
import com.chutneytesting.action.http.domain.HttpAction;
import com.chutneytesting.action.http.domain.HttpClient;
import com.chutneytesting.action.http.domain.HttpClientFactory;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.time.Duration;
import com.chutneytesting.action.spi.validation.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class HttpGetAction
implements Action {
    private static final String DEFAULT_TIMEOUT = "2000 ms";
    private final Target target;
    private final Logger logger;
    private final String uri;
    private final Map<String, String> headers;
    private final String timeout;

    public HttpGetAction(Target target, Logger logger, @Input(value="uri") String uri, @Input(value="headers") Map<String, String> headers, @Input(value="timeout") String timeout) {
        this.target = target;
        this.logger = logger;
        this.uri = uri;
        this.headers = headers != null ? headers : new HashMap();
        this.timeout = Optional.ofNullable(timeout).orElse(DEFAULT_TIMEOUT);
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom(HttpActionHelper.httpCommonValidation(this.target, this.timeout));
    }

    public ActionExecutionResult execute() {
        HttpClient httpClient = new HttpClientFactory().create(this.logger, this.target, String.class, (int)Duration.parseToMs((String)this.timeout));
        HttpHeaders httpHeaders = new HttpHeaders();
        this.headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
        Supplier<ResponseEntity<String>> caller = () -> httpClient.get(this.uri, (MultiValueMap<String, String>)httpHeaders);
        return HttpAction.httpCall(this.logger, caller);
    }
}

